/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@org.springframework.context.annotation.Configuration
@MapperScan(value={"org.apache.dolphinscheduler.*.mapper"})
public class SpringConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringConnectionFactory.class);
    protected static Configuration conf;

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    @Bean
    public DruidDataSource dataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(conf.getString("spring.datasource.driver-class-name"));
        druidDataSource.setUrl(conf.getString("spring.datasource.url"));
        druidDataSource.setUsername(conf.getString("spring.datasource.username"));
        druidDataSource.setPassword(conf.getString("spring.datasource.password"));
        druidDataSource.setValidationQuery(conf.getString("spring.datasource.validationQuery"));
        druidDataSource.setPoolPreparedStatements(conf.getBoolean("spring.datasource.poolPreparedStatements"));
        druidDataSource.setTestWhileIdle(conf.getBoolean("spring.datasource.testWhileIdle"));
        druidDataSource.setTestOnBorrow(conf.getBoolean("spring.datasource.testOnBorrow"));
        druidDataSource.setTestOnReturn(conf.getBoolean("spring.datasource.testOnReturn"));
        druidDataSource.setKeepAlive(conf.getBoolean("spring.datasource.keepAlive"));
        druidDataSource.setMinIdle(conf.getInt("spring.datasource.minIdle"));
        druidDataSource.setMaxActive(conf.getInt("spring.datasource.maxActive"));
        druidDataSource.setMaxWait((long)conf.getInt("spring.datasource.maxWait"));
        druidDataSource.setMaxPoolPreparedStatementPerConnectionSize(conf.getInt("spring.datasource.maxPoolPreparedStatementPerConnectionSize"));
        druidDataSource.setInitialSize(conf.getInt("spring.datasource.initialSize"));
        druidDataSource.setTimeBetweenEvictionRunsMillis(conf.getLong("spring.datasource.timeBetweenEvictionRunsMillis"));
        druidDataSource.setTimeBetweenConnectErrorMillis(conf.getLong("spring.datasource.timeBetweenConnectErrorMillis"));
        druidDataSource.setMinEvictableIdleTimeMillis(conf.getLong("spring.datasource.minEvictableIdleTimeMillis"));
        druidDataSource.setValidationQueryTimeout(conf.getInt("spring.datasource.validationQueryTimeout"));
        druidDataSource.setDefaultAutoCommit(conf.getBoolean("spring.datasource.defaultAutoCommit"));
        return druidDataSource;
    }

    @Bean
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager((DataSource)this.dataSource());
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory() throws Exception {
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.addMappers("org.apache.dolphinscheduler.dao.mapper");
        configuration.addInterceptor((Interceptor)this.paginationInterceptor());
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setConfiguration(configuration);
        sqlSessionFactoryBean.setDataSource((DataSource)this.dataSource());
        sqlSessionFactoryBean.setTypeEnumsPackage("org.apache.dolphinscheduler.*.enums");
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public SqlSession sqlSession() throws Exception {
        return new SqlSessionTemplate(this.sqlSessionFactory());
    }

    static {
        try {
            conf = new PropertiesConfiguration("application.properties");
        }
        catch (ConfigurationException e) {
            logger.error("load configuration exception", (Throwable)e);
            System.exit(1);
        }
    }
}

