/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.common.utils.SchemaUtils;
import org.apache.dolphinscheduler.common.utils.ScriptRunner;
import org.apache.dolphinscheduler.dao.AbstractBaseDao;
import org.apache.dolphinscheduler.dao.datasource.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpgradeDao
extends AbstractBaseDao {
    public static final Logger logger = LoggerFactory.getLogger(UpgradeDao.class);
    private static final String T_VERSION_NAME = "t_escheduler_version";
    private static final String T_NEW_VERSION_NAME = "t_ds_version";
    private static final String rootDir = System.getProperty("user.dir");
    protected static final DruidDataSource dataSource = UpgradeDao.getDataSource();
    private static final DbType dbType = UpgradeDao.getCurrentDbType();

    @Override
    protected void init() {
    }

    public static DruidDataSource getDataSource() {
        DruidDataSource dataSource = ConnectionFactory.getDataSource();
        dataSource.setInitialSize(2);
        dataSource.setMinIdle(2);
        dataSource.setMaxActive(2);
        return dataSource;
    }

    public static DbType getDbType() {
        return dbType;
    }

    private static DbType getCurrentDbType() {
        DruidPooledConnection conn = null;
        try {
            conn = dataSource.getConnection();
            String name = conn.getMetaData().getDatabaseProductName().toUpperCase();
            DbType dbType = DbType.valueOf((String)name);
            return dbType;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            DbType dbType = null;
            return dbType;
        }
        finally {
            ConnectionUtils.releaseResource(null, null, (Connection)conn);
        }
    }

    public void initSchema() {
        DbType dbType = UpgradeDao.getDbType();
        String initSqlPath = "";
        if (dbType != null) {
            switch (dbType) {
                case MYSQL: {
                    initSqlPath = "/sql/create/release-1.0.0_schema/mysql/";
                    this.initSchema(initSqlPath);
                    break;
                }
                case POSTGRESQL: {
                    initSqlPath = "/sql/create/release-1.2.0_schema/postgresql/";
                    this.initSchema(initSqlPath);
                    break;
                }
                default: {
                    logger.error("not support sql type: {},can't upgrade", (Object)dbType);
                    throw new IllegalArgumentException("not support sql type,can't upgrade");
                }
            }
        }
    }

    public void initSchema(String initSqlPath) {
        this.runInitDDL(initSqlPath);
        this.runInitDML(initSqlPath);
    }

    private void runInitDML(String initSqlPath) {
        DruidPooledConnection conn = null;
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String mysqlSQLFilePath = rootDir + initSqlPath + "dolphinscheduler_dml.sql";
        try {
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            ScriptRunner initScriptRunner = new ScriptRunner((Connection)conn, false, true);
            FileReader initSqlReader = new FileReader(new File(mysqlSQLFilePath));
            initScriptRunner.runScript((Reader)initSqlReader);
            conn.commit();
        }
        catch (IOException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            ConnectionUtils.releaseResource(null, null, (Connection)conn);
        }
    }

    private void runInitDDL(String initSqlPath) {
        DruidPooledConnection conn = null;
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String mysqlSQLFilePath = rootDir + initSqlPath + "dolphinscheduler_ddl.sql";
        try {
            conn = dataSource.getConnection();
            ScriptRunner initScriptRunner = new ScriptRunner((Connection)conn, true, true);
            FileReader initSqlReader = new FileReader(new File(mysqlSQLFilePath));
            initScriptRunner.runScript((Reader)initSqlReader);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            ConnectionUtils.releaseResource(null, null, (Connection)conn);
        }
    }

    public abstract boolean isExistsTable(String var1);

    public abstract boolean isExistsColumn(String var1, String var2);

    public String getCurrentVersion(String versionName) {
        String string;
        String sql = String.format("select version from %s", versionName);
        DruidPooledConnection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        String version = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                version = rs.getString(1);
            }
            string = version;
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((ResultSet)rs, (PreparedStatement)pstmt, (Connection)conn);
        return string;
    }

    public void upgradeDolphinScheduler(String schemaDir) {
        this.upgradeDolphinSchedulerDDL(schemaDir);
        this.upgradeDolphinSchedulerDML(schemaDir);
    }

    private void upgradeDolphinSchedulerDML(String schemaDir) {
        String schemaVersion = schemaDir.split("_")[0];
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String sqlFilePath = MessageFormat.format("{0}/sql/upgrade/{1}/{2}/dolphinscheduler_dml.sql", rootDir, schemaDir, UpgradeDao.getDbType().name().toLowerCase());
        logger.info("sqlSQLFilePath" + sqlFilePath);
        DruidPooledConnection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            ScriptRunner scriptRunner = new ScriptRunner((Connection)conn, false, true);
            FileReader sqlReader = new FileReader(new File(sqlFilePath));
            scriptRunner.runScript((Reader)sqlReader);
            if (this.isExistsTable(T_VERSION_NAME)) {
                String upgradeSQL = String.format("update %s set version = ?", T_VERSION_NAME);
                pstmt = conn.prepareStatement(upgradeSQL);
                pstmt.setString(1, schemaVersion);
                pstmt.executeUpdate();
            } else if (this.isExistsTable(T_NEW_VERSION_NAME)) {
                String upgradeSQL = String.format("update %s set version = ?", T_NEW_VERSION_NAME);
                pstmt = conn.prepareStatement(upgradeSQL);
                pstmt.setString(1, schemaVersion);
                pstmt.executeUpdate();
            }
            conn.commit();
        }
        catch (FileNotFoundException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql file not found ", e);
        }
        catch (IOException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            ConnectionUtils.releaseResource(null, pstmt, (Connection)conn);
        }
    }

    private void upgradeDolphinSchedulerDDL(String schemaDir) {
        if (StringUtils.isEmpty((CharSequence)rootDir)) {
            throw new RuntimeException("Environment variable user.dir not found");
        }
        String sqlFilePath = MessageFormat.format("{0}/sql/upgrade/{1}/{2}/dolphinscheduler_ddl.sql", rootDir, schemaDir, UpgradeDao.getDbType().name().toLowerCase());
        DruidPooledConnection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = dataSource.getConnection();
            String dbName = conn.getCatalog();
            logger.info(dbName);
            conn.setAutoCommit(true);
            ScriptRunner scriptRunner = new ScriptRunner((Connection)conn, true, true);
            FileReader sqlReader = new FileReader(new File(sqlFilePath));
            scriptRunner.runScript((Reader)sqlReader);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql file not found ", e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            ConnectionUtils.releaseResource(null, pstmt, (Connection)conn);
        }
    }

    public void updateVersion(String version) {
        String versionName = T_VERSION_NAME;
        if (!SchemaUtils.isAGreatVersion((String)"1.2.0", (String)version)) {
            versionName = T_NEW_VERSION_NAME;
        }
        String upgradeSQL = String.format("update %s set version = ?", versionName);
        PreparedStatement pstmt = null;
        DruidPooledConnection conn = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(upgradeSQL);
            pstmt.setString(1, version);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + upgradeSQL, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource(null, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource(null, (PreparedStatement)pstmt, (Connection)conn);
    }
}

