/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import com.baomidou.mybatisplus.core.toolkit.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final Properties properties = new Properties();
    private static final PropertyUtils propertyUtils = new PropertyUtils();

    private PropertyUtils() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String[] propertyFiles;
        for (String fileName : propertyFiles = new String[]{"application.properties"}) {
            InputStream fis = null;
            try {
                fis = PropertyUtils.class.getResourceAsStream(fileName);
                properties.load(fis);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (fis != null) {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                System.exit(1);
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
    }

    public static String getString(String key) {
        return properties.getProperty(key);
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = PropertyUtils.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }
}

