/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.TaskRecordStatus;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskRecord;
import org.apache.dolphinscheduler.dao.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRecordDao {
    private static Logger logger = LoggerFactory.getLogger((String)TaskRecordDao.class.getName());

    public static boolean getTaskRecordFlag() {
        return PropertyUtils.getBoolean("task.record.flag", false);
    }

    private static Connection getConn() {
        if (!TaskRecordDao.getTaskRecordFlag()) {
            return null;
        }
        String driver = "com.mysql.jdbc.Driver";
        String url = PropertyUtils.getString("task.record.datasource.url");
        String username = PropertyUtils.getString("task.record.datasource.username");
        String password = PropertyUtils.getString("task.record.datasource.password");
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (ClassNotFoundException e) {
            logger.error("Class not found Exception ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQL Exception ", (Throwable)e);
        }
        return conn;
    }

    private static String getWhereString(Map<String, String> filterMap) {
        String end;
        String start;
        String sourceTable;
        String state;
        String taskDate;
        if (filterMap.size() == 0) {
            return "";
        }
        String result = " where 1=1 ";
        String taskName = filterMap.get("taskName");
        if (taskName != null && StringUtils.isNotEmpty((CharSequence)taskName.toString())) {
            result = result + " and PROC_NAME like concat('%', '" + taskName.toString() + "', '%') ";
        }
        if ((taskDate = filterMap.get("taskDate")) != null && StringUtils.isNotEmpty((CharSequence)taskDate.toString())) {
            result = result + " and PROC_DATE='" + taskDate.toString() + "'";
        }
        if ((state = filterMap.get("state")) != null && StringUtils.isNotEmpty((CharSequence)state.toString())) {
            result = result + " and NOTE='" + state.toString() + "'";
        }
        if ((sourceTable = filterMap.get("sourceTable")) != null && StringUtils.isNotEmpty((CharSequence)sourceTable.toString())) {
            result = result + " and SOURCE_TAB like concat('%', '" + sourceTable.toString() + "', '%')";
        }
        String targetTable = filterMap.get("targetTable");
        if (sourceTable != null && StringUtils.isNotEmpty((CharSequence)targetTable.toString())) {
            result = result + " and TARGET_TAB like concat('%', '" + targetTable.toString() + "', '%') ";
        }
        if ((start = filterMap.get("startTime")) != null && StringUtils.isNotEmpty((CharSequence)start.toString())) {
            result = result + " and STARTDATE>='" + start.toString() + "'";
        }
        if ((end = filterMap.get("endTime")) != null && StringUtils.isNotEmpty((CharSequence)end.toString())) {
            result = result + " and ENDDATE>='" + end.toString() + "'";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countTaskRecord(Map<String, String> filterMap, String table) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        int count;
        block6: {
            block5: {
                count = 0;
                conn = null;
                pstmt = null;
                rs = null;
                conn = TaskRecordDao.getConn();
                if (conn != null) break block5;
                int n = count;
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                return n;
            }
            try {
                String sql = String.format("select count(1) as count from %s", table);
                sql = sql + TaskRecordDao.getWhereString(filterMap);
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                count = rs.getInt("count");
            }
            catch (SQLException e) {
                try {
                    logger.error("Exception ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                    throw throwable;
                }
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return count;
    }

    public static List<TaskRecord> queryAllTaskRecord(Map<String, String> filterMap, String table) {
        String sql = String.format("select * from  %s", table);
        sql = sql + TaskRecordDao.getWhereString(filterMap);
        int offset = Integer.parseInt(filterMap.get("offset"));
        int pageSize = Integer.parseInt(filterMap.get("pageSize"));
        sql = sql + String.format(" order by STARTDATE desc limit %d,%d", offset, pageSize);
        ArrayList<TaskRecord> recordList = new ArrayList();
        try {
            recordList = TaskRecordDao.getQueryResult(sql);
        }
        catch (Exception e) {
            logger.error("Exception ", (Throwable)e);
        }
        return recordList;
    }

    private static TaskRecord convertToTaskRecord(ResultSet resultSet) throws SQLException {
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(resultSet.getInt("ID"));
        taskRecord.setProcId(resultSet.getInt("PROC_ID"));
        taskRecord.setProcName(resultSet.getString("PROC_NAME"));
        taskRecord.setProcDate(resultSet.getString("PROC_DATE"));
        taskRecord.setStartTime(DateUtils.stringToDate((String)resultSet.getString("STARTDATE")));
        taskRecord.setEndTime(DateUtils.stringToDate((String)resultSet.getString("ENDDATE")));
        taskRecord.setResult(resultSet.getString("RESULT"));
        taskRecord.setDuration(resultSet.getInt("DURATION"));
        taskRecord.setNote(resultSet.getString("NOTE"));
        taskRecord.setSchema(resultSet.getString("SCHEMA"));
        taskRecord.setJobId(resultSet.getString("JOB_ID"));
        taskRecord.setSourceTab(resultSet.getString("SOURCE_TAB"));
        taskRecord.setSourceRowCount(resultSet.getLong("SOURCE_ROW_COUNT"));
        taskRecord.setTargetTab(resultSet.getString("TARGET_TAB"));
        taskRecord.setTargetRowCount(resultSet.getLong("TARGET_ROW_COUNT"));
        taskRecord.setErrorCode(resultSet.getString("ERROR_CODE"));
        return taskRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TaskRecord> getQueryResult(String selectSql) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        ArrayList<TaskRecord> recordList;
        block6: {
            recordList = new ArrayList<TaskRecord>();
            conn = null;
            pstmt = null;
            rs = null;
            conn = TaskRecordDao.getConn();
            if (conn != null) break block6;
            ArrayList<TaskRecord> arrayList = recordList;
            ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
            return arrayList;
        }
        try {
            pstmt = conn.prepareStatement(selectSql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                TaskRecord taskRecord = TaskRecordDao.convertToTaskRecord(rs);
                recordList.add(taskRecord);
            }
        }
        catch (SQLException e) {
            try {
                logger.error("Exception ", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                throw throwable;
            }
            ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return recordList;
    }

    public static TaskRecordStatus getTaskRecordState(String procName, String procDate) {
        String sql = String.format("SELECT * FROM eamp_hive_log_hd WHERE PROC_NAME='%s' and PROC_DATE like '%s'", procName, procDate + "%");
        List<TaskRecord> taskRecordList = TaskRecordDao.getQueryResult(sql);
        if (CollectionUtils.isEmpty(taskRecordList)) {
            return TaskRecordStatus.EXCEPTION;
        }
        if (taskRecordList.size() > 1) {
            return TaskRecordStatus.EXCEPTION;
        }
        TaskRecord taskRecord = taskRecordList.get(0);
        if (taskRecord == null) {
            return TaskRecordStatus.EXCEPTION;
        }
        Long targetRowCount = taskRecord.getTargetRowCount();
        if (targetRowCount <= 0L) {
            return TaskRecordStatus.FAILURE;
        }
        return TaskRecordStatus.SUCCESS;
    }
}

