/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.dao.upgrade.UpgradeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlUpgradeDao
extends UpgradeDao {
    public static final Logger logger = LoggerFactory.getLogger(PostgresqlUpgradeDao.class);
    private static final String SCHEMA = PostgresqlUpgradeDao.getSchema();

    private PostgresqlUpgradeDao() {
    }

    public static final PostgresqlUpgradeDao getInstance() {
        return PostgresqlUpgradeDaoHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSchema() {
        conn = null;
        pstmt = null;
        resultSet = null;
        try {
            conn = PostgresqlUpgradeDao.dataSource.getConnection();
            pstmt = conn.prepareStatement("select current_schema()");
            resultSet = pstmt.executeQuery();
            while (resultSet.next()) {
                if (!resultSet.isFirst()) continue;
                var3_3 = resultSet.getString(1);
                ** GOTO lbl20
            }
            ** GOTO lbl22
        }
        catch (SQLException e) {
            try {
                PostgresqlUpgradeDao.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable var4_5) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{resultSet, pstmt, conn});
                throw var4_5;
            }
lbl20:
            // 1 sources

            ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{resultSet, pstmt, conn});
            return var3_3;
lbl22:
            // 1 sources

            ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{resultSet, pstmt, conn});
            return "";
            ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{resultSet, pstmt, conn});
            return "";
        }
    }

    @Override
    public boolean isExistsTable(String tableName) {
        boolean bl;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            rs = conn.getMetaData().getTables(null, SCHEMA, tableName, null);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
        return bl;
    }

    @Override
    public boolean isExistsColumn(String tableName, String columnName) {
        boolean bl;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            rs = conn.getMetaData().getColumns(null, SCHEMA, tableName, columnName);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
        return bl;
    }

    private static class PostgresqlUpgradeDaoHolder {
        private static final PostgresqlUpgradeDao INSTANCE = new PostgresqlUpgradeDao();

        private PostgresqlUpgradeDaoHolder() {
        }
    }
}

