/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDataSource
extends BaseDataSource {
    private static final Logger logger = LoggerFactory.getLogger(MySQLDataSource.class);
    private static final String ALLOW_LOAD_LOCAL_IN_FILE_NAME = "allowLoadLocalInfile";
    private static final String AUTO_DESERIALIZE = "autoDeserialize";
    private static final String ALLOW_LOCAL_IN_FILE_NAME = "allowLocalInfile";
    private static final String ALLOW_URL_IN_LOCAL_IN_FILE_NAME = "allowUrlInLocalInfile";
    private static final String APPEND_PARAMS = "allowLoadLocalInfile=false&autoDeserialize=false&allowLocalInfile=false&allowUrlInLocalInfile=false";

    private static boolean checkKeyIsLegitimate(String key) {
        return !key.contains(ALLOW_LOAD_LOCAL_IN_FILE_NAME) && !key.contains(AUTO_DESERIALIZE) && !key.contains(ALLOW_LOCAL_IN_FILE_NAME) && !key.contains(ALLOW_URL_IN_LOCAL_IN_FILE_NAME);
    }

    @Override
    public String driverClassSelector() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.MYSQL;
    }

    public static Map<String, String> buildOtherParams(Map<String, String> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            return null;
        }
        LinkedHashMap<String, String> newParamMap = new LinkedHashMap<String, String>();
        paramMap.forEach((k, v) -> {
            if (!MySQLDataSource.checkKeyIsLegitimate(k)) {
                return;
            }
            newParamMap.put((String)k, (String)v);
        });
        return newParamMap;
    }

    @Override
    public String getUser() {
        if (this.user.contains(AUTO_DESERIALIZE)) {
            logger.warn("sensitive param : {} in username field is filtered", (Object)AUTO_DESERIALIZE);
            this.user = this.user.replace(AUTO_DESERIALIZE, "");
        }
        logger.debug("username : {}", (Object)this.user);
        return this.user;
    }

    @Override
    protected String filterOther(String otherParams) {
        if (StringUtils.isBlank((CharSequence)otherParams)) {
            return APPEND_PARAMS;
        }
        char symbol = '&';
        return otherParams + symbol + APPEND_PARAMS;
    }

    @Override
    public String getPassword() {
        this.password = super.getPassword();
        if (this.password.contains(AUTO_DESERIALIZE)) {
            logger.warn("sensitive param : {} in password field is filtered", (Object)AUTO_DESERIALIZE);
            this.password = this.password.replace(AUTO_DESERIALIZE, "");
        }
        return this.password;
    }
}

