/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.dao.upgrade.UpgradeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlUpgradeDao
extends UpgradeDao {
    public static final Logger logger = LoggerFactory.getLogger(MysqlUpgradeDao.class);

    private MysqlUpgradeDao() {
    }

    public static final MysqlUpgradeDao getInstance() {
        return MysqlUpgradeDaoHolder.INSTANCE;
    }

    @Override
    public boolean isExistsTable(String tableName) {
        boolean bl;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            rs = conn.getMetaData().getTables(null, null, tableName, null);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
        return bl;
    }

    @Override
    public boolean isExistsColumn(String tableName, String columnName) {
        boolean bl;
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            ResultSet rs = conn.getMetaData().getColumns(null, null, tableName, columnName);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
        return bl;
    }

    private static class MysqlUpgradeDaoHolder {
        private static final MysqlUpgradeDao INSTANCE = new MysqlUpgradeDao();

        private MysqlUpgradeDaoHolder() {
        }
    }
}

