/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import com.baomidou.mybatisplus.core.toolkit.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final Properties properties = new Properties();
    private static final PropertyUtils propertyUtils = new PropertyUtils();

    private PropertyUtils() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String[] propertyFiles;
        for (String fileName : propertyFiles = new String[]{"/datasource.properties"}) {
            InputStream fis = null;
            try {
                fis = PropertyUtils.class.getResourceAsStream(fileName);
                properties.load(fis);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (fis != null) {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                System.exit(1);
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
    }

    public static String getString(String key) {
        return properties.getProperty(key);
    }

    public static String getString(String key, String defaultVal) {
        String val = properties.getProperty(key.trim());
        return val == null ? defaultVal : val;
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = PropertyUtils.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static Boolean getBoolean(String key) {
        String value = properties.getProperty(key.trim());
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static Boolean getBoolean(String key, boolean defaultValue) {
        String value = properties.getProperty(key.trim());
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static long getLong(String key, long defaultVal) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultVal : Long.parseLong(val);
    }
}

