/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.dao.entity.MonitorRecord;
import org.apache.dolphinscheduler.dao.utils.MysqlPerformance;
import org.apache.dolphinscheduler.dao.utils.PostgrePerformance;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorDBDao {
    private static Logger logger = LoggerFactory.getLogger(MonitorDBDao.class);
    public static final String VARIABLE_NAME = "variable_name";
    @Autowired
    private HikariDataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorRecord getCurrentDbPerformance() {
        Connection conn;
        MonitorRecord monitorRecord;
        block6: {
            MonitorRecord monitorRecord2;
            String driverClassName;
            block5: {
                monitorRecord = null;
                conn = null;
                conn = this.dataSource.getConnection();
                driverClassName = this.dataSource.getDriverClassName();
                if (!driverClassName.contains(DbType.MYSQL.toString().toLowerCase())) break block5;
                MonitorRecord monitorRecord3 = new MysqlPerformance().getMonitorRecord(conn);
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                return monitorRecord3;
            }
            try {
                if (!driverClassName.contains(DbType.POSTGRESQL.toString().toLowerCase())) break block6;
                monitorRecord2 = new PostgrePerformance().getMonitorRecord(conn);
            }
            catch (Exception e) {
                try {
                    logger.error("SQLException: {}", (Object)e.getMessage(), (Object)e);
                }
                catch (Throwable throwable) {
                    ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                    throw throwable;
                }
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
            }
            ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
            return monitorRecord2;
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
        return monitorRecord;
    }

    public List<MonitorRecord> queryDatabaseState() {
        ArrayList<MonitorRecord> list = new ArrayList<MonitorRecord>(1);
        MonitorRecord monitorRecord = this.getCurrentDbPerformance();
        if (monitorRecord != null) {
            list.add(monitorRecord);
        }
        return list;
    }
}

