/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.upgrade.SchemaUtils;
import org.apache.dolphinscheduler.dao.upgrade.UpgradeDao;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"shell-cli"})
public class DolphinSchedulerManager {
    private static final Logger logger = LoggerFactory.getLogger(DolphinSchedulerManager.class);
    private final UpgradeDao upgradeDao;

    public DolphinSchedulerManager(DataSource dataSource, List<UpgradeDao> daos) throws Exception {
        DbType type = this.getCurrentDbType(dataSource);
        this.upgradeDao = daos.stream().filter(it -> it.getDbType() == type).findFirst().orElseThrow(() -> new RuntimeException("Cannot find UpgradeDao implementation for db type: " + type));
    }

    private DbType getCurrentDbType(DataSource dataSource) throws Exception {
        try (Connection conn = dataSource.getConnection();){
            String name = conn.getMetaData().getDatabaseProductName().toUpperCase();
            DbType dbType = DbType.valueOf((String)name);
            return dbType;
        }
    }

    public void initDolphinScheduler() {
        this.initDolphinSchedulerSchema();
    }

    public boolean schemaIsInitialized() {
        if (this.upgradeDao.isExistsTable("t_escheduler_version") || this.upgradeDao.isExistsTable("t_ds_version") || this.upgradeDao.isExistsTable("t_escheduler_queue")) {
            logger.info("The database has been initialized. Skip the initialization step");
            return true;
        }
        return false;
    }

    public void initDolphinSchedulerSchema() {
        logger.info("Start initializing the DolphinScheduler manager table structure");
        this.upgradeDao.initSchema();
    }

    public void upgradeDolphinScheduler() throws IOException {
        List<String> schemaList = SchemaUtils.getAllSchemaList();
        if (schemaList == null || schemaList.size() == 0) {
            logger.info("There is no schema to upgrade!");
        } else {
            String version;
            if (this.upgradeDao.isExistsTable("t_escheduler_version")) {
                version = this.upgradeDao.getCurrentVersion("t_escheduler_version");
            } else if (this.upgradeDao.isExistsTable("t_ds_version")) {
                version = this.upgradeDao.getCurrentVersion("t_ds_version");
            } else if (this.upgradeDao.isExistsColumn("t_escheduler_queue", "create_time")) {
                version = "1.0.1";
            } else if (this.upgradeDao.isExistsTable("t_escheduler_queue")) {
                version = "1.0.0";
            } else {
                logger.error("Unable to determine current software version, so cannot upgrade");
                throw new RuntimeException("Unable to determine current software version, so cannot upgrade");
            }
            String schemaVersion = "";
            for (String schemaDir : schemaList) {
                schemaVersion = schemaDir.split("_")[0];
                if (!SchemaUtils.isAGreatVersion(schemaVersion, version)) continue;
                logger.info("upgrade DolphinScheduler metadata version from {} to {}", (Object)version, (Object)schemaVersion);
                logger.info("Begin upgrading DolphinScheduler's table structure");
                this.upgradeDao.upgradeDolphinScheduler(schemaDir);
                if ("1.3.0".equals(schemaVersion)) {
                    this.upgradeDao.upgradeDolphinSchedulerWorkerGroup();
                } else if ("1.3.2".equals(schemaVersion)) {
                    this.upgradeDao.upgradeDolphinSchedulerResourceList();
                } else if ("2.0.0".equals(schemaVersion)) {
                    this.upgradeDao.upgradeDolphinSchedulerTo200(schemaDir);
                }
                version = schemaVersion;
            }
        }
        this.upgradeDao.updateVersion(SchemaUtils.getSoftVersion());
    }
}

