/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.dao.upgrade.UpgradeDao;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"shell-cli"})
public class MysqlUpgradeDao
extends UpgradeDao {
    public static final Logger logger = LoggerFactory.getLogger(MysqlUpgradeDao.class);

    private MysqlUpgradeDao(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String initSqlPath() {
        return "create/release-1.0.0_schema/mysql";
    }

    @Override
    protected DbType getDbType() {
        return DbType.MYSQL;
    }

    @Override
    public boolean isExistsTable(String tableName) {
        boolean bl;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            rs = conn.getMetaData().getTables(conn.getCatalog(), conn.getSchema(), tableName, null);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, conn});
        return bl;
    }

    @Override
    public boolean isExistsColumn(String tableName, String columnName) {
        boolean bl;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            ResultSet rs = conn.getMetaData().getColumns(conn.getCatalog(), conn.getSchema(), tableName, columnName);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
        return bl;
    }
}

