/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;

@TableName(value="t_ds_process_instance")
public class ProcessInstance {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    private Long processDefinitionCode;
    private int processDefinitionVersion;
    private ExecutionStatus state;
    private Flag recovery;
    private Date startTime;
    private Date endTime;
    private int runTimes;
    private String name;
    private String host;
    @TableField(exist=false)
    private ProcessDefinition processDefinition;
    private CommandType commandType;
    private String commandParam;
    private TaskDependType taskDependType;
    private int maxTryTimes;
    private FailureStrategy failureStrategy;
    private WarningType warningType;
    private Integer warningGroupId;
    private Date scheduleTime;
    private Date commandStartTime;
    private String globalParams;
    @TableField(exist=false)
    private DagData dagData;
    private int executorId;
    @TableField(exist=false)
    private String executorName;
    @TableField(exist=false)
    private String tenantCode;
    @TableField(exist=false)
    private String queue;
    private Flag isSubProcess;
    @TableField(exist=false)
    private String locations;
    private String historyCmd;
    @TableField(exist=false)
    private String dependenceScheduleTimes;
    @TableField(exist=false)
    private String duration;
    private Priority processInstancePriority;
    private String workerGroup;
    private Long environmentCode;
    private int timeout;
    private int tenantId;
    private String varPool;
    private int nextProcessInstanceId;
    private int dryRun;
    private Date restartTime;
    @TableField(exist=false)
    private boolean isBlocked;

    public ProcessInstance() {
    }

    public ProcessInstance(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
        this.name = String.join((CharSequence)"-", processDefinition.getName(), String.valueOf(processDefinition.getVersion()), DateUtils.getCurrentTimeStamp());
    }

    public String getVarPool() {
        return this.varPool;
    }

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ExecutionStatus getState() {
        return this.state;
    }

    public void setState(ExecutionStatus state) {
        this.state = state;
    }

    public Flag getRecovery() {
        return this.recovery;
    }

    public void setRecovery(Flag recovery) {
        this.recovery = recovery;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getRunTimes() {
        return this.runTimes;
    }

    public void setRunTimes(int runTimes) {
        this.runTimes = runTimes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public String getCommandParam() {
        return this.commandParam;
    }

    public void setCommandParam(String commandParam) {
        this.commandParam = commandParam;
    }

    public TaskDependType getTaskDependType() {
        return this.taskDependType;
    }

    public void setTaskDependType(TaskDependType taskDependType) {
        this.taskDependType = taskDependType;
    }

    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    public void setMaxTryTimes(int maxTryTimes) {
        this.maxTryTimes = maxTryTimes;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void setFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    public boolean isProcessInstanceStop() {
        return this.state.typeIsFinished();
    }

    public WarningType getWarningType() {
        return this.warningType;
    }

    public void setWarningType(WarningType warningType) {
        this.warningType = warningType;
    }

    public Integer getWarningGroupId() {
        return this.warningGroupId;
    }

    public void setWarningGroupId(Integer warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public Date getCommandStartTime() {
        return this.commandStartTime;
    }

    public void setCommandStartTime(Date commandStartTime) {
        this.commandStartTime = commandStartTime;
    }

    public String getGlobalParams() {
        return this.globalParams;
    }

    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    public DagData getDagData() {
        return this.dagData;
    }

    public void setDagData(DagData dagData) {
        this.dagData = dagData;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public void setExecutorId(int executorId) {
        this.executorId = executorId;
    }

    public Flag getIsSubProcess() {
        return this.isSubProcess;
    }

    public void setIsSubProcess(Flag isSubProcess) {
        this.isSubProcess = isSubProcess;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String locations) {
        this.locations = locations;
    }

    public String getHistoryCmd() {
        return this.historyCmd;
    }

    public void setHistoryCmd(String historyCmd) {
        this.historyCmd = historyCmd;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public Long getEnvironmentCode() {
        return this.environmentCode;
    }

    public void setEnvironmentCode(Long environmentCode) {
        this.environmentCode = environmentCode;
    }

    public int getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(int dryRun) {
        this.dryRun = dryRun;
    }

    public Date getRestartTime() {
        return this.restartTime;
    }

    public void setRestartTime(Date restartTime) {
        this.restartTime = restartTime;
    }

    public void addHistoryCmd(CommandType cmd) {
        this.historyCmd = StringUtils.isNotEmpty((String)this.historyCmd) ? String.format("%s,%s", this.historyCmd, cmd.toString()) : cmd.toString();
    }

    public boolean isComplementData() {
        if (StringUtils.isEmpty((String)this.historyCmd)) {
            return false;
        }
        return this.historyCmd.startsWith(CommandType.COMPLEMENT_DATA.toString());
    }

    public CommandType getCmdTypeIfComplement() {
        if (this.isComplementData()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return this.commandType;
    }

    public String getDependenceScheduleTimes() {
        return this.dependenceScheduleTimes;
    }

    public void setDependenceScheduleTimes(String dependenceScheduleTimes) {
        this.dependenceScheduleTimes = dependenceScheduleTimes;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public Long getProcessDefinitionCode() {
        return this.processDefinitionCode;
    }

    public void setProcessDefinitionCode(Long processDefinitionCode) {
        this.processDefinitionCode = processDefinitionCode;
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public String toString() {
        return "ProcessInstance{id=" + this.id + ", state=" + this.state + ", recovery=" + this.recovery + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", runTimes=" + this.runTimes + ", name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", processDefinition=" + this.processDefinition + ", commandType=" + this.commandType + ", commandParam='" + this.commandParam + '\'' + ", taskDependType=" + this.taskDependType + ", maxTryTimes=" + this.maxTryTimes + ", failureStrategy=" + this.failureStrategy + ", warningType=" + this.warningType + ", warningGroupId=" + this.warningGroupId + ", scheduleTime=" + this.scheduleTime + ", commandStartTime=" + this.commandStartTime + ", globalParams='" + this.globalParams + '\'' + ", executorId=" + this.executorId + ", tenantCode='" + this.tenantCode + '\'' + ", queue='" + this.queue + '\'' + ", isSubProcess=" + this.isSubProcess + ", locations='" + this.locations + '\'' + ", historyCmd='" + this.historyCmd + '\'' + ", dependenceScheduleTimes='" + this.dependenceScheduleTimes + '\'' + ", duration=" + this.duration + ", processInstancePriority=" + this.processInstancePriority + ", workerGroup='" + this.workerGroup + '\'' + ", timeout=" + this.timeout + ", tenantId=" + this.tenantId + ", processDefinitionCode='" + this.processDefinitionCode + '\'' + ", processDefinitionVersion='" + this.processDefinitionVersion + '\'' + ", dryRun='" + this.dryRun + '\'' + '}' + ", restartTime='" + this.restartTime + '\'' + ", isBlocked=" + this.isBlocked + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstance that = (ProcessInstance)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public int getNextProcessInstanceId() {
        return this.nextProcessInstanceId;
    }

    public void setNextProcessInstanceId(int nextProcessInstanceId) {
        this.nextProcessInstanceId = nextProcessInstanceId;
    }
}

