/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ProcessExecutionTypeEnum;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;

@TableName(value="t_ds_process_definition")
public class ProcessDefinition {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    private long code;
    private String name;
    private int version;
    private ReleaseState releaseState;
    private long projectCode;
    private String description;
    private String globalParams;
    @TableField(exist=false)
    private List<Property> globalParamList;
    @TableField(exist=false)
    private Map<String, String> globalParamMap;
    private Date createTime;
    private Date updateTime;
    private Flag flag;
    private int userId;
    @TableField(exist=false)
    private String userName;
    @TableField(exist=false)
    private String projectName;
    private String locations;
    @TableField(exist=false)
    private ReleaseState scheduleReleaseState;
    private int timeout;
    private int tenantId;
    @TableField(exist=false)
    private String tenantCode;
    @TableField(exist=false)
    private String modifyBy;
    @TableField(exist=false)
    private int warningGroupId;
    private ProcessExecutionTypeEnum executionType;

    public ProcessDefinition(long projectCode, String name, long code, String description, String globalParams, String locations, int timeout, int userId, int tenantId) {
        Date date;
        this.set(projectCode, name, description, globalParams, locations, timeout, tenantId);
        this.code = code;
        this.userId = userId;
        this.createTime = date = new Date();
        this.updateTime = date;
    }

    public void set(long projectCode, String name, String description, String globalParams, String locations, int timeout, int tenantId) {
        this.projectCode = projectCode;
        this.name = name;
        this.description = description;
        this.globalParams = globalParams;
        this.locations = locations;
        this.timeout = timeout;
        this.tenantId = tenantId;
        this.flag = Flag.YES;
    }

    public void setGlobalParams(String globalParams) {
        this.globalParamList = JSONUtils.toList((String)globalParams, Property.class);
        if (this.globalParamList == null) {
            this.globalParamList = new ArrayList<Property>();
        }
        this.globalParams = globalParams;
    }

    public Map<String, String> getGlobalParamMap() {
        if (this.globalParamMap == null && !Strings.isNullOrEmpty((String)this.globalParams)) {
            List propList = JSONUtils.toList((String)this.globalParams, Property.class);
            this.globalParamMap = propList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        }
        return this.globalParamMap;
    }

    @Generated
    public static ProcessDefinitionBuilder builder() {
        return new ProcessDefinitionBuilder();
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public long getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public ReleaseState getReleaseState() {
        return this.releaseState;
    }

    @Generated
    public long getProjectCode() {
        return this.projectCode;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getGlobalParams() {
        return this.globalParams;
    }

    @Generated
    public List<Property> getGlobalParamList() {
        return this.globalParamList;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Flag getFlag() {
        return this.flag;
    }

    @Generated
    public int getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getLocations() {
        return this.locations;
    }

    @Generated
    public ReleaseState getScheduleReleaseState() {
        return this.scheduleReleaseState;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getTenantCode() {
        return this.tenantCode;
    }

    @Generated
    public String getModifyBy() {
        return this.modifyBy;
    }

    @Generated
    public int getWarningGroupId() {
        return this.warningGroupId;
    }

    @Generated
    public ProcessExecutionTypeEnum getExecutionType() {
        return this.executionType;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setCode(long code) {
        this.code = code;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(int version) {
        this.version = version;
    }

    @Generated
    public void setReleaseState(ReleaseState releaseState) {
        this.releaseState = releaseState;
    }

    @Generated
    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setGlobalParamList(List<Property> globalParamList) {
        this.globalParamList = globalParamList;
    }

    @Generated
    public void setGlobalParamMap(Map<String, String> globalParamMap) {
        this.globalParamMap = globalParamMap;
    }

    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    @Generated
    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setLocations(String locations) {
        this.locations = locations;
    }

    @Generated
    public void setScheduleReleaseState(ReleaseState scheduleReleaseState) {
        this.scheduleReleaseState = scheduleReleaseState;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @Generated
    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    @Generated
    public void setWarningGroupId(int warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    @Generated
    public void setExecutionType(ProcessExecutionTypeEnum executionType) {
        this.executionType = executionType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessDefinition)) {
            return false;
        }
        ProcessDefinition other = (ProcessDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getProjectCode() != other.getProjectCode()) {
            return false;
        }
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getTenantId() != other.getTenantId()) {
            return false;
        }
        if (this.getWarningGroupId() != other.getWarningGroupId()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ReleaseState this$releaseState = this.getReleaseState();
        ReleaseState other$releaseState = other.getReleaseState();
        if (this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        List<Property> this$globalParamList = this.getGlobalParamList();
        List<Property> other$globalParamList = other.getGlobalParamList();
        if (this$globalParamList == null ? other$globalParamList != null : !((Object)this$globalParamList).equals(other$globalParamList)) {
            return false;
        }
        Map<String, String> this$globalParamMap = this.getGlobalParamMap();
        Map<String, String> other$globalParamMap = other.getGlobalParamMap();
        if (this$globalParamMap == null ? other$globalParamMap != null : !((Object)this$globalParamMap).equals(other$globalParamMap)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Flag this$flag = this.getFlag();
        Flag other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !this$flag.equals(other$flag)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$locations = this.getLocations();
        String other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !this$locations.equals(other$locations)) {
            return false;
        }
        ReleaseState this$scheduleReleaseState = this.getScheduleReleaseState();
        ReleaseState other$scheduleReleaseState = other.getScheduleReleaseState();
        if (this$scheduleReleaseState == null ? other$scheduleReleaseState != null : !this$scheduleReleaseState.equals(other$scheduleReleaseState)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        String this$modifyBy = this.getModifyBy();
        String other$modifyBy = other.getModifyBy();
        if (this$modifyBy == null ? other$modifyBy != null : !this$modifyBy.equals(other$modifyBy)) {
            return false;
        }
        ProcessExecutionTypeEnum this$executionType = this.getExecutionType();
        ProcessExecutionTypeEnum other$executionType = other.getExecutionType();
        return !(this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $code = this.getCode();
        result = result * 59 + (int)($code >>> 32 ^ $code);
        result = result * 59 + this.getVersion();
        long $projectCode = this.getProjectCode();
        result = result * 59 + (int)($projectCode >>> 32 ^ $projectCode);
        result = result * 59 + this.getUserId();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getTenantId();
        result = result * 59 + this.getWarningGroupId();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ReleaseState $releaseState = this.getReleaseState();
        result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        List<Property> $globalParamList = this.getGlobalParamList();
        result = result * 59 + ($globalParamList == null ? 43 : ((Object)$globalParamList).hashCode());
        Map<String, String> $globalParamMap = this.getGlobalParamMap();
        result = result * 59 + ($globalParamMap == null ? 43 : ((Object)$globalParamMap).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Flag $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : $flag.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : $locations.hashCode());
        ReleaseState $scheduleReleaseState = this.getScheduleReleaseState();
        result = result * 59 + ($scheduleReleaseState == null ? 43 : $scheduleReleaseState.hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        String $modifyBy = this.getModifyBy();
        result = result * 59 + ($modifyBy == null ? 43 : $modifyBy.hashCode());
        ProcessExecutionTypeEnum $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProcessDefinition(id=" + this.getId() + ", code=" + this.getCode() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", releaseState=" + this.getReleaseState() + ", projectCode=" + this.getProjectCode() + ", description=" + this.getDescription() + ", globalParams=" + this.getGlobalParams() + ", globalParamList=" + this.getGlobalParamList() + ", globalParamMap=" + this.getGlobalParamMap() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", flag=" + this.getFlag() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", projectName=" + this.getProjectName() + ", locations=" + this.getLocations() + ", scheduleReleaseState=" + this.getScheduleReleaseState() + ", timeout=" + this.getTimeout() + ", tenantId=" + this.getTenantId() + ", tenantCode=" + this.getTenantCode() + ", modifyBy=" + this.getModifyBy() + ", warningGroupId=" + this.getWarningGroupId() + ", executionType=" + this.getExecutionType() + ")";
    }

    @Generated
    public ProcessDefinition() {
    }

    @Generated
    public ProcessDefinition(Integer id, long code, String name, int version, ReleaseState releaseState, long projectCode, String description, String globalParams, List<Property> globalParamList, Map<String, String> globalParamMap, Date createTime, Date updateTime, Flag flag, int userId, String userName, String projectName, String locations, ReleaseState scheduleReleaseState, int timeout, int tenantId, String tenantCode, String modifyBy, int warningGroupId, ProcessExecutionTypeEnum executionType) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.version = version;
        this.releaseState = releaseState;
        this.projectCode = projectCode;
        this.description = description;
        this.globalParams = globalParams;
        this.globalParamList = globalParamList;
        this.globalParamMap = globalParamMap;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.flag = flag;
        this.userId = userId;
        this.userName = userName;
        this.projectName = projectName;
        this.locations = locations;
        this.scheduleReleaseState = scheduleReleaseState;
        this.timeout = timeout;
        this.tenantId = tenantId;
        this.tenantCode = tenantCode;
        this.modifyBy = modifyBy;
        this.warningGroupId = warningGroupId;
        this.executionType = executionType;
    }

    @Generated
    public static class ProcessDefinitionBuilder {
        @Generated
        private Integer id;
        @Generated
        private long code;
        @Generated
        private String name;
        @Generated
        private int version;
        @Generated
        private ReleaseState releaseState;
        @Generated
        private long projectCode;
        @Generated
        private String description;
        @Generated
        private String globalParams;
        @Generated
        private List<Property> globalParamList;
        @Generated
        private Map<String, String> globalParamMap;
        @Generated
        private Date createTime;
        @Generated
        private Date updateTime;
        @Generated
        private Flag flag;
        @Generated
        private int userId;
        @Generated
        private String userName;
        @Generated
        private String projectName;
        @Generated
        private String locations;
        @Generated
        private ReleaseState scheduleReleaseState;
        @Generated
        private int timeout;
        @Generated
        private int tenantId;
        @Generated
        private String tenantCode;
        @Generated
        private String modifyBy;
        @Generated
        private int warningGroupId;
        @Generated
        private ProcessExecutionTypeEnum executionType;

        @Generated
        ProcessDefinitionBuilder() {
        }

        @Generated
        public ProcessDefinitionBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder code(long code) {
            this.code = code;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder version(int version) {
            this.version = version;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder releaseState(ReleaseState releaseState) {
            this.releaseState = releaseState;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder projectCode(long projectCode) {
            this.projectCode = projectCode;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder globalParams(String globalParams) {
            this.globalParams = globalParams;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder globalParamList(List<Property> globalParamList) {
            this.globalParamList = globalParamList;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder globalParamMap(Map<String, String> globalParamMap) {
            this.globalParamMap = globalParamMap;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder updateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder flag(Flag flag) {
            this.flag = flag;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder userId(int userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder locations(String locations) {
            this.locations = locations;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder scheduleReleaseState(ReleaseState scheduleReleaseState) {
            this.scheduleReleaseState = scheduleReleaseState;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder tenantId(int tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder tenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder modifyBy(String modifyBy) {
            this.modifyBy = modifyBy;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder warningGroupId(int warningGroupId) {
            this.warningGroupId = warningGroupId;
            return this;
        }

        @Generated
        public ProcessDefinitionBuilder executionType(ProcessExecutionTypeEnum executionType) {
            this.executionType = executionType;
            return this;
        }

        @Generated
        public ProcessDefinition build() {
            return new ProcessDefinition(this.id, this.code, this.name, this.version, this.releaseState, this.projectCode, this.description, this.globalParams, this.globalParamList, this.globalParamMap, this.createTime, this.updateTime, this.flag, this.userId, this.userName, this.projectName, this.locations, this.scheduleReleaseState, this.timeout, this.tenantId, this.tenantCode, this.modifyBy, this.warningGroupId, this.executionType);
        }

        @Generated
        public String toString() {
            return "ProcessDefinition.ProcessDefinitionBuilder(id=" + this.id + ", code=" + this.code + ", name=" + this.name + ", version=" + this.version + ", releaseState=" + this.releaseState + ", projectCode=" + this.projectCode + ", description=" + this.description + ", globalParams=" + this.globalParams + ", globalParamList=" + this.globalParamList + ", globalParamMap=" + this.globalParamMap + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", flag=" + this.flag + ", userId=" + this.userId + ", userName=" + this.userName + ", projectName=" + this.projectName + ", locations=" + this.locations + ", scheduleReleaseState=" + this.scheduleReleaseState + ", timeout=" + this.timeout + ", tenantId=" + this.tenantId + ", tenantCode=" + this.tenantCode + ", modifyBy=" + this.modifyBy + ", warningGroupId=" + this.warningGroupId + ", executionType=" + this.executionType + ")";
        }
    }
}

