/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: GeneralRPC.proto

package org.apache.drill.exec.proto;

public final class GeneralRPCProtos {
  private GeneralRPCProtos() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code exec.rpc.RpcMode}
   */
  public enum RpcMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>REQUEST = 0;</code>
     */
    REQUEST(0, 0),
    /**
     * <code>RESPONSE = 1;</code>
     */
    RESPONSE(1, 1),
    /**
     * <code>RESPONSE_FAILURE = 2;</code>
     */
    RESPONSE_FAILURE(2, 2),
    /**
     * <code>PING = 3;</code>
     */
    PING(3, 3),
    /**
     * <code>PONG = 4;</code>
     */
    PONG(4, 4),
    ;

    /**
     * <code>REQUEST = 0;</code>
     */
    public static final int REQUEST_VALUE = 0;
    /**
     * <code>RESPONSE = 1;</code>
     */
    public static final int RESPONSE_VALUE = 1;
    /**
     * <code>RESPONSE_FAILURE = 2;</code>
     */
    public static final int RESPONSE_FAILURE_VALUE = 2;
    /**
     * <code>PING = 3;</code>
     */
    public static final int PING_VALUE = 3;
    /**
     * <code>PONG = 4;</code>
     */
    public static final int PONG_VALUE = 4;


    public final int getNumber() { return value; }

    public static RpcMode valueOf(int value) {
      switch (value) {
        case 0: return REQUEST;
        case 1: return RESPONSE;
        case 2: return RESPONSE_FAILURE;
        case 3: return PING;
        case 4: return PONG;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RpcMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<RpcMode>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RpcMode>() {
            public RpcMode findValueByNumber(int number) {
              return RpcMode.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.GeneralRPCProtos.getDescriptor().getEnumTypes().get(0);
    }

    private static final RpcMode[] VALUES = values();

    public static RpcMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private RpcMode(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.rpc.RpcMode)
  }

  public interface AckOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional bool ok = 1;
    /**
     * <code>optional bool ok = 1;</code>
     */
    boolean hasOk();
    /**
     * <code>optional bool ok = 1;</code>
     */
    boolean getOk();
  }
  /**
   * Protobuf type {@code exec.rpc.Ack}
   */
  public static final class Ack extends
      com.google.protobuf.GeneratedMessage
      implements AckOrBuilder {
    // Use Ack.newBuilder() to construct.
    private Ack(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Ack(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Ack defaultInstance;
    public static Ack getDefaultInstance() {
      return defaultInstance;
    }

    public Ack getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Ack(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              ok_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_Ack_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_Ack_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.GeneralRPCProtos.Ack.class, org.apache.drill.exec.proto.GeneralRPCProtos.Ack.Builder.class);
    }

    public static com.google.protobuf.Parser<Ack> PARSER =
        new com.google.protobuf.AbstractParser<Ack>() {
      public Ack parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Ack(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Ack> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional bool ok = 1;
    public static final int OK_FIELD_NUMBER = 1;
    private boolean ok_;
    /**
     * <code>optional bool ok = 1;</code>
     */
    public boolean hasOk() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional bool ok = 1;</code>
     */
    public boolean getOk() {
      return ok_;
    }

    private void initFields() {
      ok_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBool(1, ok_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, ok_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.Ack parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.GeneralRPCProtos.Ack prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.rpc.Ack}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.GeneralRPCProtos.AckOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_Ack_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_Ack_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.GeneralRPCProtos.Ack.class, org.apache.drill.exec.proto.GeneralRPCProtos.Ack.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.GeneralRPCProtos.Ack.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        ok_ = false;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_Ack_descriptor;
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.Ack getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.Ack.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.Ack build() {
        org.apache.drill.exec.proto.GeneralRPCProtos.Ack result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.Ack buildPartial() {
        org.apache.drill.exec.proto.GeneralRPCProtos.Ack result = new org.apache.drill.exec.proto.GeneralRPCProtos.Ack(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ok_ = ok_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.GeneralRPCProtos.Ack) {
          return mergeFrom((org.apache.drill.exec.proto.GeneralRPCProtos.Ack)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.GeneralRPCProtos.Ack other) {
        if (other == org.apache.drill.exec.proto.GeneralRPCProtos.Ack.getDefaultInstance()) return this;
        if (other.hasOk()) {
          setOk(other.getOk());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.GeneralRPCProtos.Ack parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.GeneralRPCProtos.Ack) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional bool ok = 1;
      private boolean ok_ ;
      /**
       * <code>optional bool ok = 1;</code>
       */
      public boolean hasOk() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional bool ok = 1;</code>
       */
      public boolean getOk() {
        return ok_;
      }
      /**
       * <code>optional bool ok = 1;</code>
       */
      public Builder setOk(boolean value) {
        bitField0_ |= 0x00000001;
        ok_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool ok = 1;</code>
       */
      public Builder clearOk() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ok_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.rpc.Ack)
    }

    static {
      defaultInstance = new Ack(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.rpc.Ack)
  }

  public interface RpcHeaderOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.rpc.RpcMode mode = 1;
    /**
     * <code>optional .exec.rpc.RpcMode mode = 1;</code>
     */
    boolean hasMode();
    /**
     * <code>optional .exec.rpc.RpcMode mode = 1;</code>
     */
    org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode getMode();

    // optional int32 coordination_id = 2;
    /**
     * <code>optional int32 coordination_id = 2;</code>
     *
     * <pre>
     * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
     * </pre>
     */
    boolean hasCoordinationId();
    /**
     * <code>optional int32 coordination_id = 2;</code>
     *
     * <pre>
     * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
     * </pre>
     */
    int getCoordinationId();

    // optional int32 rpc_type = 3;
    /**
     * <code>optional int32 rpc_type = 3;</code>
     *
     * <pre>
     * a rpc mode specific rpc type.
     * </pre>
     */
    boolean hasRpcType();
    /**
     * <code>optional int32 rpc_type = 3;</code>
     *
     * <pre>
     * a rpc mode specific rpc type.
     * </pre>
     */
    int getRpcType();
  }
  /**
   * Protobuf type {@code exec.rpc.RpcHeader}
   */
  public static final class RpcHeader extends
      com.google.protobuf.GeneratedMessage
      implements RpcHeaderOrBuilder {
    // Use RpcHeader.newBuilder() to construct.
    private RpcHeader(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private RpcHeader(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final RpcHeader defaultInstance;
    public static RpcHeader getDefaultInstance() {
      return defaultInstance;
    }

    public RpcHeader getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private RpcHeader(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode value = org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                mode_ = value;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              coordinationId_ = input.readInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              rpcType_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_RpcHeader_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_RpcHeader_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.class, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder.class);
    }

    public static com.google.protobuf.Parser<RpcHeader> PARSER =
        new com.google.protobuf.AbstractParser<RpcHeader>() {
      public RpcHeader parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new RpcHeader(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<RpcHeader> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.rpc.RpcMode mode = 1;
    public static final int MODE_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode mode_;
    /**
     * <code>optional .exec.rpc.RpcMode mode = 1;</code>
     */
    public boolean hasMode() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.rpc.RpcMode mode = 1;</code>
     */
    public org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode getMode() {
      return mode_;
    }

    // optional int32 coordination_id = 2;
    public static final int COORDINATION_ID_FIELD_NUMBER = 2;
    private int coordinationId_;
    /**
     * <code>optional int32 coordination_id = 2;</code>
     *
     * <pre>
     * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
     * </pre>
     */
    public boolean hasCoordinationId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional int32 coordination_id = 2;</code>
     *
     * <pre>
     * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
     * </pre>
     */
    public int getCoordinationId() {
      return coordinationId_;
    }

    // optional int32 rpc_type = 3;
    public static final int RPC_TYPE_FIELD_NUMBER = 3;
    private int rpcType_;
    /**
     * <code>optional int32 rpc_type = 3;</code>
     *
     * <pre>
     * a rpc mode specific rpc type.
     * </pre>
     */
    public boolean hasRpcType() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int32 rpc_type = 3;</code>
     *
     * <pre>
     * a rpc mode specific rpc type.
     * </pre>
     */
    public int getRpcType() {
      return rpcType_;
    }

    private void initFields() {
      mode_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode.REQUEST;
      coordinationId_ = 0;
      rpcType_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, mode_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, coordinationId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, rpcType_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, mode_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, coordinationId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, rpcType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.rpc.RpcHeader}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeaderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_RpcHeader_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_RpcHeader_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.class, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        mode_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode.REQUEST;
        bitField0_ = (bitField0_ & ~0x00000001);
        coordinationId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        rpcType_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_RpcHeader_descriptor;
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader build() {
        org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader buildPartial() {
        org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader result = new org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.mode_ = mode_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.coordinationId_ = coordinationId_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.rpcType_ = rpcType_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader) {
          return mergeFrom((org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader other) {
        if (other == org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.getDefaultInstance()) return this;
        if (other.hasMode()) {
          setMode(other.getMode());
        }
        if (other.hasCoordinationId()) {
          setCoordinationId(other.getCoordinationId());
        }
        if (other.hasRpcType()) {
          setRpcType(other.getRpcType());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.rpc.RpcMode mode = 1;
      private org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode mode_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode.REQUEST;
      /**
       * <code>optional .exec.rpc.RpcMode mode = 1;</code>
       */
      public boolean hasMode() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.rpc.RpcMode mode = 1;</code>
       */
      public org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode getMode() {
        return mode_;
      }
      /**
       * <code>optional .exec.rpc.RpcMode mode = 1;</code>
       */
      public Builder setMode(org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        mode_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.rpc.RpcMode mode = 1;</code>
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mode_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcMode.REQUEST;
        onChanged();
        return this;
      }

      // optional int32 coordination_id = 2;
      private int coordinationId_ ;
      /**
       * <code>optional int32 coordination_id = 2;</code>
       *
       * <pre>
       * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
       * </pre>
       */
      public boolean hasCoordinationId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional int32 coordination_id = 2;</code>
       *
       * <pre>
       * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
       * </pre>
       */
      public int getCoordinationId() {
        return coordinationId_;
      }
      /**
       * <code>optional int32 coordination_id = 2;</code>
       *
       * <pre>
       * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
       * </pre>
       */
      public Builder setCoordinationId(int value) {
        bitField0_ |= 0x00000002;
        coordinationId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 coordination_id = 2;</code>
       *
       * <pre>
       * reusable coordination identifier.  Sender defines.  Server returns on return.  Irrelevant for purely single direction rpc.
       * </pre>
       */
      public Builder clearCoordinationId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        coordinationId_ = 0;
        onChanged();
        return this;
      }

      // optional int32 rpc_type = 3;
      private int rpcType_ ;
      /**
       * <code>optional int32 rpc_type = 3;</code>
       *
       * <pre>
       * a rpc mode specific rpc type.
       * </pre>
       */
      public boolean hasRpcType() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional int32 rpc_type = 3;</code>
       *
       * <pre>
       * a rpc mode specific rpc type.
       * </pre>
       */
      public int getRpcType() {
        return rpcType_;
      }
      /**
       * <code>optional int32 rpc_type = 3;</code>
       *
       * <pre>
       * a rpc mode specific rpc type.
       * </pre>
       */
      public Builder setRpcType(int value) {
        bitField0_ |= 0x00000004;
        rpcType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_type = 3;</code>
       *
       * <pre>
       * a rpc mode specific rpc type.
       * </pre>
       */
      public Builder clearRpcType() {
        bitField0_ = (bitField0_ & ~0x00000004);
        rpcType_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.rpc.RpcHeader)
    }

    static {
      defaultInstance = new RpcHeader(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.rpc.RpcHeader)
  }

  public interface CompleteRpcMessageOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.rpc.RpcHeader header = 1;
    /**
     * <code>optional .exec.rpc.RpcHeader header = 1;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    boolean hasHeader();
    /**
     * <code>optional .exec.rpc.RpcHeader header = 1;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader getHeader();
    /**
     * <code>optional .exec.rpc.RpcHeader header = 1;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeaderOrBuilder getHeaderOrBuilder();

    // optional bytes protobuf_body = 2;
    /**
     * <code>optional bytes protobuf_body = 2;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    boolean hasProtobufBody();
    /**
     * <code>optional bytes protobuf_body = 2;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    com.google.protobuf.ByteString getProtobufBody();

    // optional bytes raw_body = 3;
    /**
     * <code>optional bytes raw_body = 3;</code>
     *
     * <pre>
     * optional
     * </pre>
     */
    boolean hasRawBody();
    /**
     * <code>optional bytes raw_body = 3;</code>
     *
     * <pre>
     * optional
     * </pre>
     */
    com.google.protobuf.ByteString getRawBody();
  }
  /**
   * Protobuf type {@code exec.rpc.CompleteRpcMessage}
   */
  public static final class CompleteRpcMessage extends
      com.google.protobuf.GeneratedMessage
      implements CompleteRpcMessageOrBuilder {
    // Use CompleteRpcMessage.newBuilder() to construct.
    private CompleteRpcMessage(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CompleteRpcMessage(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CompleteRpcMessage defaultInstance;
    public static CompleteRpcMessage getDefaultInstance() {
      return defaultInstance;
    }

    public CompleteRpcMessage getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CompleteRpcMessage(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = header_.toBuilder();
              }
              header_ = input.readMessage(org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(header_);
                header_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              protobufBody_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              rawBody_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_CompleteRpcMessage_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_CompleteRpcMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage.class, org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage.Builder.class);
    }

    public static com.google.protobuf.Parser<CompleteRpcMessage> PARSER =
        new com.google.protobuf.AbstractParser<CompleteRpcMessage>() {
      public CompleteRpcMessage parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CompleteRpcMessage(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CompleteRpcMessage> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.rpc.RpcHeader header = 1;
    public static final int HEADER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader header_;
    /**
     * <code>optional .exec.rpc.RpcHeader header = 1;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    public boolean hasHeader() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.rpc.RpcHeader header = 1;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader getHeader() {
      return header_;
    }
    /**
     * <code>optional .exec.rpc.RpcHeader header = 1;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeaderOrBuilder getHeaderOrBuilder() {
      return header_;
    }

    // optional bytes protobuf_body = 2;
    public static final int PROTOBUF_BODY_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString protobufBody_;
    /**
     * <code>optional bytes protobuf_body = 2;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    public boolean hasProtobufBody() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bytes protobuf_body = 2;</code>
     *
     * <pre>
     * required
     * </pre>
     */
    public com.google.protobuf.ByteString getProtobufBody() {
      return protobufBody_;
    }

    // optional bytes raw_body = 3;
    public static final int RAW_BODY_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString rawBody_;
    /**
     * <code>optional bytes raw_body = 3;</code>
     *
     * <pre>
     * optional
     * </pre>
     */
    public boolean hasRawBody() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bytes raw_body = 3;</code>
     *
     * <pre>
     * optional
     * </pre>
     */
    public com.google.protobuf.ByteString getRawBody() {
      return rawBody_;
    }

    private void initFields() {
      header_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.getDefaultInstance();
      protobufBody_ = com.google.protobuf.ByteString.EMPTY;
      rawBody_ = com.google.protobuf.ByteString.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, header_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, protobufBody_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, rawBody_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, header_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, protobufBody_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, rawBody_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.rpc.CompleteRpcMessage}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_CompleteRpcMessage_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_CompleteRpcMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage.class, org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getHeaderFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (headerBuilder_ == null) {
          header_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.getDefaultInstance();
        } else {
          headerBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        protobufBody_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        rawBody_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.internal_static_exec_rpc_CompleteRpcMessage_descriptor;
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage build() {
        org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage buildPartial() {
        org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage result = new org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (headerBuilder_ == null) {
          result.header_ = header_;
        } else {
          result.header_ = headerBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.protobufBody_ = protobufBody_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.rawBody_ = rawBody_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage) {
          return mergeFrom((org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage other) {
        if (other == org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage.getDefaultInstance()) return this;
        if (other.hasHeader()) {
          mergeHeader(other.getHeader());
        }
        if (other.hasProtobufBody()) {
          setProtobufBody(other.getProtobufBody());
        }
        if (other.hasRawBody()) {
          setRawBody(other.getRawBody());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.GeneralRPCProtos.CompleteRpcMessage) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.rpc.RpcHeader header = 1;
      private org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader header_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeaderOrBuilder> headerBuilder_;
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public boolean hasHeader() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader getHeader() {
        if (headerBuilder_ == null) {
          return header_;
        } else {
          return headerBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public Builder setHeader(org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader value) {
        if (headerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          header_ = value;
          onChanged();
        } else {
          headerBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public Builder setHeader(
          org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder builderForValue) {
        if (headerBuilder_ == null) {
          header_ = builderForValue.build();
          onChanged();
        } else {
          headerBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public Builder mergeHeader(org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader value) {
        if (headerBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              header_ != org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.getDefaultInstance()) {
            header_ =
              org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.newBuilder(header_).mergeFrom(value).buildPartial();
          } else {
            header_ = value;
          }
          onChanged();
        } else {
          headerBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public Builder clearHeader() {
        if (headerBuilder_ == null) {
          header_ = org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.getDefaultInstance();
          onChanged();
        } else {
          headerBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder getHeaderBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getHeaderFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeaderOrBuilder getHeaderOrBuilder() {
        if (headerBuilder_ != null) {
          return headerBuilder_.getMessageOrBuilder();
        } else {
          return header_;
        }
      }
      /**
       * <code>optional .exec.rpc.RpcHeader header = 1;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeaderOrBuilder> 
          getHeaderFieldBuilder() {
        if (headerBuilder_ == null) {
          headerBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeader.Builder, org.apache.drill.exec.proto.GeneralRPCProtos.RpcHeaderOrBuilder>(
                  header_,
                  getParentForChildren(),
                  isClean());
          header_ = null;
        }
        return headerBuilder_;
      }

      // optional bytes protobuf_body = 2;
      private com.google.protobuf.ByteString protobufBody_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes protobuf_body = 2;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public boolean hasProtobufBody() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bytes protobuf_body = 2;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public com.google.protobuf.ByteString getProtobufBody() {
        return protobufBody_;
      }
      /**
       * <code>optional bytes protobuf_body = 2;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public Builder setProtobufBody(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        protobufBody_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes protobuf_body = 2;</code>
       *
       * <pre>
       * required
       * </pre>
       */
      public Builder clearProtobufBody() {
        bitField0_ = (bitField0_ & ~0x00000002);
        protobufBody_ = getDefaultInstance().getProtobufBody();
        onChanged();
        return this;
      }

      // optional bytes raw_body = 3;
      private com.google.protobuf.ByteString rawBody_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes raw_body = 3;</code>
       *
       * <pre>
       * optional
       * </pre>
       */
      public boolean hasRawBody() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional bytes raw_body = 3;</code>
       *
       * <pre>
       * optional
       * </pre>
       */
      public com.google.protobuf.ByteString getRawBody() {
        return rawBody_;
      }
      /**
       * <code>optional bytes raw_body = 3;</code>
       *
       * <pre>
       * optional
       * </pre>
       */
      public Builder setRawBody(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        rawBody_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes raw_body = 3;</code>
       *
       * <pre>
       * optional
       * </pre>
       */
      public Builder clearRawBody() {
        bitField0_ = (bitField0_ & ~0x00000004);
        rawBody_ = getDefaultInstance().getRawBody();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.rpc.CompleteRpcMessage)
    }

    static {
      defaultInstance = new CompleteRpcMessage(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.rpc.CompleteRpcMessage)
  }

  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_rpc_Ack_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_rpc_Ack_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_rpc_RpcHeader_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_rpc_RpcHeader_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_rpc_CompleteRpcMessage_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_rpc_CompleteRpcMessage_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\020GeneralRPC.proto\022\010exec.rpc\032\022Coordinati" +
      "on.proto\"\021\n\003Ack\022\n\n\002ok\030\001 \001(\010\"W\n\tRpcHeader" +
      "\022\037\n\004mode\030\001 \001(\0162\021.exec.rpc.RpcMode\022\027\n\017coo" +
      "rdination_id\030\002 \001(\005\022\020\n\010rpc_type\030\003 \001(\005\"b\n\022" +
      "CompleteRpcMessage\022#\n\006header\030\001 \001(\0132\023.exe" +
      "c.rpc.RpcHeader\022\025\n\rprotobuf_body\030\002 \001(\014\022\020" +
      "\n\010raw_body\030\003 \001(\014*N\n\007RpcMode\022\013\n\007REQUEST\020\000" +
      "\022\014\n\010RESPONSE\020\001\022\024\n\020RESPONSE_FAILURE\020\002\022\010\n\004" +
      "PING\020\003\022\010\n\004PONG\020\004B1\n\033org.apache.drill.exe" +
      "c.protoB\020GeneralRPCProtosH\001"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
      new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
        public com.google.protobuf.ExtensionRegistry assignDescriptors(
            com.google.protobuf.Descriptors.FileDescriptor root) {
          descriptor = root;
          internal_static_exec_rpc_Ack_descriptor =
            getDescriptor().getMessageTypes().get(0);
          internal_static_exec_rpc_Ack_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_rpc_Ack_descriptor,
              new java.lang.String[] { "Ok", });
          internal_static_exec_rpc_RpcHeader_descriptor =
            getDescriptor().getMessageTypes().get(1);
          internal_static_exec_rpc_RpcHeader_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_rpc_RpcHeader_descriptor,
              new java.lang.String[] { "Mode", "CoordinationId", "RpcType", });
          internal_static_exec_rpc_CompleteRpcMessage_descriptor =
            getDescriptor().getMessageTypes().get(2);
          internal_static_exec_rpc_CompleteRpcMessage_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_rpc_CompleteRpcMessage_descriptor,
              new java.lang.String[] { "Header", "ProtobufBody", "RawBody", });
          return null;
        }
      };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.apache.drill.exec.proto.CoordinationProtos.getDescriptor(),
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
