/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class BitControlHandshake implements Externalizable, Message<BitControlHandshake>, Schema<BitControlHandshake>
{

    public static Schema<BitControlHandshake> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static BitControlHandshake getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final BitControlHandshake DEFAULT_INSTANCE = new BitControlHandshake();

    
    private int rpcVersion;
    private RpcChannel channel;
    private DrillbitEndpoint endpoint;

    public BitControlHandshake()
    {
        
    }

    // getters and setters

    // rpcVersion

    public int getRpcVersion()
    {
        return rpcVersion;
    }

    public BitControlHandshake setRpcVersion(int rpcVersion)
    {
        this.rpcVersion = rpcVersion;
        return this;
    }

    // channel

    public RpcChannel getChannel()
    {
        return channel == null ? RpcChannel.BIT_CONTROL : channel;
    }

    public BitControlHandshake setChannel(RpcChannel channel)
    {
        this.channel = channel;
        return this;
    }

    // endpoint

    public DrillbitEndpoint getEndpoint()
    {
        return endpoint;
    }

    public BitControlHandshake setEndpoint(DrillbitEndpoint endpoint)
    {
        this.endpoint = endpoint;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<BitControlHandshake> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public BitControlHandshake newMessage()
    {
        return new BitControlHandshake();
    }

    public Class<BitControlHandshake> typeClass()
    {
        return BitControlHandshake.class;
    }

    public String messageName()
    {
        return BitControlHandshake.class.getSimpleName();
    }

    public String messageFullName()
    {
        return BitControlHandshake.class.getName();
    }

    public boolean isInitialized(BitControlHandshake message)
    {
        return true;
    }

    public void mergeFrom(Input input, BitControlHandshake message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.rpcVersion = input.readInt32();
                    break;
                case 2:
                    message.channel = RpcChannel.valueOf(input.readEnum());
                    break;
                case 3:
                    message.endpoint = input.mergeObject(message.endpoint, DrillbitEndpoint.getSchema());
                    break;

                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, BitControlHandshake message) throws IOException
    {
        if(message.rpcVersion != 0)
            output.writeInt32(1, message.rpcVersion, false);

        if(message.channel != null)
             output.writeEnum(2, message.channel.number, false);

        if(message.endpoint != null)
             output.writeObject(3, message.endpoint, DrillbitEndpoint.getSchema(), false);

    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "rpcVersion";
            case 2: return "channel";
            case 3: return "endpoint";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("rpcVersion", 1);
        __fieldMap.put("channel", 2);
        __fieldMap.put("endpoint", 3);
    }
    
}
