/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class FragmentRecordBatch implements Externalizable, Message<FragmentRecordBatch>, Schema<FragmentRecordBatch>
{

    public static Schema<FragmentRecordBatch> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static FragmentRecordBatch getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final FragmentRecordBatch DEFAULT_INSTANCE = new FragmentRecordBatch();

    static final Boolean DEFAULT_IS_OUT_OF_MEMORY = new Boolean(false);
    
    private QueryId queryId;
    private int receivingMajorFragmentId;
    private List<Integer> receivingMinorFragmentId;
    private int sendingMajorFragmentId;
    private int sendingMinorFragmentId;
    private RecordBatchDef def;
    private Boolean isLastBatch;
    private Boolean isOutOfMemory = DEFAULT_IS_OUT_OF_MEMORY;

    public FragmentRecordBatch()
    {
        
    }

    // getters and setters

    // queryId

    public QueryId getQueryId()
    {
        return queryId;
    }

    public FragmentRecordBatch setQueryId(QueryId queryId)
    {
        this.queryId = queryId;
        return this;
    }

    // receivingMajorFragmentId

    public int getReceivingMajorFragmentId()
    {
        return receivingMajorFragmentId;
    }

    public FragmentRecordBatch setReceivingMajorFragmentId(int receivingMajorFragmentId)
    {
        this.receivingMajorFragmentId = receivingMajorFragmentId;
        return this;
    }

    // receivingMinorFragmentId

    public List<Integer> getReceivingMinorFragmentIdList()
    {
        return receivingMinorFragmentId;
    }

    public FragmentRecordBatch setReceivingMinorFragmentIdList(List<Integer> receivingMinorFragmentId)
    {
        this.receivingMinorFragmentId = receivingMinorFragmentId;
        return this;
    }

    // sendingMajorFragmentId

    public int getSendingMajorFragmentId()
    {
        return sendingMajorFragmentId;
    }

    public FragmentRecordBatch setSendingMajorFragmentId(int sendingMajorFragmentId)
    {
        this.sendingMajorFragmentId = sendingMajorFragmentId;
        return this;
    }

    // sendingMinorFragmentId

    public int getSendingMinorFragmentId()
    {
        return sendingMinorFragmentId;
    }

    public FragmentRecordBatch setSendingMinorFragmentId(int sendingMinorFragmentId)
    {
        this.sendingMinorFragmentId = sendingMinorFragmentId;
        return this;
    }

    // def

    public RecordBatchDef getDef()
    {
        return def;
    }

    public FragmentRecordBatch setDef(RecordBatchDef def)
    {
        this.def = def;
        return this;
    }

    // isLastBatch

    public Boolean getIsLastBatch()
    {
        return isLastBatch;
    }

    public FragmentRecordBatch setIsLastBatch(Boolean isLastBatch)
    {
        this.isLastBatch = isLastBatch;
        return this;
    }

    // isOutOfMemory

    public Boolean getIsOutOfMemory()
    {
        return isOutOfMemory;
    }

    public FragmentRecordBatch setIsOutOfMemory(Boolean isOutOfMemory)
    {
        this.isOutOfMemory = isOutOfMemory;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<FragmentRecordBatch> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public FragmentRecordBatch newMessage()
    {
        return new FragmentRecordBatch();
    }

    public Class<FragmentRecordBatch> typeClass()
    {
        return FragmentRecordBatch.class;
    }

    public String messageName()
    {
        return FragmentRecordBatch.class.getSimpleName();
    }

    public String messageFullName()
    {
        return FragmentRecordBatch.class.getName();
    }

    public boolean isInitialized(FragmentRecordBatch message)
    {
        return true;
    }

    public void mergeFrom(Input input, FragmentRecordBatch message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.queryId = input.mergeObject(message.queryId, QueryId.getSchema());
                    break;

                case 2:
                    message.receivingMajorFragmentId = input.readInt32();
                    break;
                case 3:
                    if(message.receivingMinorFragmentId == null)
                        message.receivingMinorFragmentId = new ArrayList<Integer>();
                    message.receivingMinorFragmentId.add(input.readInt32());
                    break;
                case 4:
                    message.sendingMajorFragmentId = input.readInt32();
                    break;
                case 5:
                    message.sendingMinorFragmentId = input.readInt32();
                    break;
                case 6:
                    message.def = input.mergeObject(message.def, RecordBatchDef.getSchema());
                    break;

                case 7:
                    message.isLastBatch = input.readBool();
                    break;
                case 8:
                    message.isOutOfMemory = input.readBool();
                    break;
                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, FragmentRecordBatch message) throws IOException
    {
        if(message.queryId != null)
             output.writeObject(1, message.queryId, QueryId.getSchema(), false);


        if(message.receivingMajorFragmentId != 0)
            output.writeInt32(2, message.receivingMajorFragmentId, false);

        if(message.receivingMinorFragmentId != null)
        {
            for(Integer receivingMinorFragmentId : message.receivingMinorFragmentId)
            {
                if(receivingMinorFragmentId != null)
                    output.writeInt32(3, receivingMinorFragmentId, true);
            }
        }

        if(message.sendingMajorFragmentId != 0)
            output.writeInt32(4, message.sendingMajorFragmentId, false);

        if(message.sendingMinorFragmentId != 0)
            output.writeInt32(5, message.sendingMinorFragmentId, false);

        if(message.def != null)
             output.writeObject(6, message.def, RecordBatchDef.getSchema(), false);


        if(message.isLastBatch != null)
            output.writeBool(7, message.isLastBatch, false);

        if(message.isOutOfMemory != null && message.isOutOfMemory != DEFAULT_IS_OUT_OF_MEMORY)
            output.writeBool(8, message.isOutOfMemory, false);
    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "queryId";
            case 2: return "receivingMajorFragmentId";
            case 3: return "receivingMinorFragmentId";
            case 4: return "sendingMajorFragmentId";
            case 5: return "sendingMinorFragmentId";
            case 6: return "def";
            case 7: return "isLastBatch";
            case 8: return "isOutOfMemory";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("queryId", 1);
        __fieldMap.put("receivingMajorFragmentId", 2);
        __fieldMap.put("receivingMinorFragmentId", 3);
        __fieldMap.put("sendingMajorFragmentId", 4);
        __fieldMap.put("sendingMinorFragmentId", 5);
        __fieldMap.put("def", 6);
        __fieldMap.put("isLastBatch", 7);
        __fieldMap.put("isOutOfMemory", 8);
    }
    
}
