/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import net.hydromatic.avatica.DriverVersion;
import net.hydromatic.avatica.Handler;
import net.hydromatic.avatica.UnregisteredDriver;
import org.apache.drill.jdbc.impl.DrillHandler;

public class DriverImpl
extends UnregisteredDriver {
    private static final String CONNECTION_STRING_PREFIX = "jdbc:drill:";
    private static final String METADATA_PROPERTIES_RESOURCE_PATH = "apache-drill-jdbc.properties";

    protected String getConnectStringPrefix() {
        return CONNECTION_STRING_PREFIX;
    }

    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "org.apache.drill.jdbc.impl.DrillJdbc3Factory";
            }
            case JDBC_40: {
                return "org.apache.drill.jdbc.impl.DrillJdbc40Factory";
            }
        }
        return "org.apache.drill.jdbc.impl.DrillJdbc41Factory";
    }

    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(((Object)((Object)this)).getClass(), (String)METADATA_PROPERTIES_RESOURCE_PATH, (String)"Apache Drill JDBC Driver", (String)"<Properties resource apache-drill-jdbc.properties not loaded>", (String)"Apache Drill", (String)"<Properties resource apache-drill-jdbc.properties not loaded>");
    }

    protected Handler createHandler() {
        return new DrillHandler();
    }
}

