/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;
import org.apache.druid.client.AbstractCuratorServerInventoryView;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.SingleServerInventoryView;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.timeline.DataSegment;

@Deprecated
@ManageLifecycle
public class BatchServerInventoryView
extends AbstractCuratorServerInventoryView<Set<DataSegment>>
implements FilteredServerInventoryView {
    private static final EmittingLogger log = new EmittingLogger(BatchServerInventoryView.class);
    private final ConcurrentMap<String, Set<DataSegment>> zNodes = new ConcurrentHashMap<String, Set<DataSegment>>();
    private final ConcurrentMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>> segmentPredicates = new ConcurrentHashMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>>();
    private final Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter;

    @Inject
    public BatchServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper, Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getLiveSegmentsPath(), curator, jsonMapper, new TypeReference<Set<DataSegment>>(){});
        this.defaultFilter = (Predicate)Preconditions.checkNotNull(defaultFilter);
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Set<DataSegment> filteredInventory = this.filterInventory(container, inventory);
        this.zNodes.put(inventoryKey, filteredInventory);
        for (DataSegment segment : filteredInventory) {
            this.addSingleInventory(container, segment);
        }
        return container;
    }

    private Set<DataSegment> filterInventory(final DruidServer container, Set<DataSegment> inventory) {
        Predicate predicate = Predicates.or(this.defaultFilter, (Predicate)Predicates.or(this.segmentPredicates.values()));
        HashSet filteredInventory = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform(inventory, (Function)new Function<DataSegment, Pair<DruidServerMetadata, DataSegment>>(){

            public Pair<DruidServerMetadata, DataSegment> apply(DataSegment input) {
                return Pair.of((Object)container.getMetadata(), (Object)input);
            }
        }), (Predicate)predicate), (Function)new Function<Pair<DruidServerMetadata, DataSegment>, DataSegment>(){

            public DataSegment apply(Pair<DruidServerMetadata, DataSegment> input) {
                return (DataSegment)input.rhs;
            }
        }));
        return filteredInventory;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Set<DataSegment> filteredInventory = this.filterInventory(container, inventory);
        Set existing = (Set)this.zNodes.get(inventoryKey);
        if (existing == null) {
            throw new ISE("Trying to update an inventoryKey[%s] that didn't exist?!", new Object[]{inventoryKey});
        }
        for (DataSegment segment : Sets.difference(filteredInventory, (Set)existing)) {
            this.addSingleInventory(container, segment);
        }
        for (DataSegment segment : Sets.difference((Set)existing, filteredInventory)) {
            this.removeSingleInventory(container, segment.getId());
        }
        this.zNodes.put(inventoryKey, filteredInventory);
        return container;
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        log.debug("Server[%s] removed container[%s]", new Object[]{container.getName(), inventoryKey});
        Set segments = (Set)this.zNodes.remove(inventoryKey);
        if (segments == null) {
            log.warn("Told to remove container[%s], which didn't exist", new Object[]{inventoryKey});
            return container;
        }
        for (DataSegment segment : segments) {
            this.removeSingleInventory(container, segment.getId());
        }
        return container;
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
        SingleServerInventoryView.FilteringSegmentCallback filteringCallback = new SingleServerInventoryView.FilteringSegmentCallback(callback, filter);
        this.segmentPredicates.put(filteringCallback, filter);
        this.registerSegmentCallback(exec, filteringCallback);
    }

    @Override
    protected void segmentCallbackRemoved(ServerView.SegmentCallback callback) {
        this.segmentPredicates.remove(callback);
    }
}

