/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class DataSourcesSnapshot {
    private final Map<String, ImmutableDruidDataSource> dataSources;
    private final ImmutableSet<SegmentId> overshadowedSegments;

    public DataSourcesSnapshot(Map<String, ImmutableDruidDataSource> dataSources) {
        this.dataSources = dataSources;
        this.overshadowedSegments = ImmutableSet.copyOf(this.determineOvershadowedSegments());
    }

    public Collection<ImmutableDruidDataSource> getDataSources() {
        return this.dataSources.values();
    }

    public Map<String, ImmutableDruidDataSource> getDataSourcesMap() {
        return this.dataSources;
    }

    @Nullable
    public ImmutableDruidDataSource getDataSource(String dataSourceName) {
        return this.dataSources.get(dataSourceName);
    }

    public ImmutableSet<SegmentId> getOvershadowedSegments() {
        return this.overshadowedSegments;
    }

    @Nullable
    public Iterable<DataSegment> iterateAllSegmentsInSnapshot() {
        if (this.dataSources == null) {
            return null;
        }
        return () -> this.dataSources.values().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator();
    }

    private List<SegmentId> determineOvershadowedSegments() {
        List<DataSegment> segments = this.dataSources.values().stream().flatMap(ds -> ds.getSegments().stream()).collect(Collectors.toList());
        HashMap timelines = new HashMap();
        segments.forEach(segment -> timelines.computeIfAbsent(segment.getDataSource(), dataSource -> new VersionedIntervalTimeline((Comparator)Ordering.natural())).add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk(segment)));
        ArrayList<SegmentId> overshadowedSegments = new ArrayList<SegmentId>();
        for (DataSegment dataSegment : segments) {
            VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null || !timeline.isOvershadowed(dataSegment.getInterval(), (Object)dataSegment.getVersion())) continue;
            overshadowedSegments.add(dataSegment.getId());
        }
        return overshadowedSegments;
    }
}

