/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.server.coordinator.BytesAccumulatingResponseHandler;

public class JsonParserIterator<T>
implements Iterator<T>,
Closeable {
    private JsonParser jp;
    private ObjectCodec objectCodec;
    private final JavaType typeRef;
    private final Future<InputStream> future;
    private final Query<T> query;
    private final String url;
    private final String host;
    private final ObjectMapper objectMapper;
    private final BytesAccumulatingResponseHandler responseHandler;

    public JsonParserIterator(JavaType typeRef, Future<InputStream> future, String url, Query<T> query, String host, ObjectMapper objectMapper, BytesAccumulatingResponseHandler responseHandler) {
        this.typeRef = typeRef;
        this.future = future;
        this.url = url;
        this.query = query;
        this.jp = null;
        this.host = host;
        this.objectMapper = objectMapper;
        this.responseHandler = responseHandler;
    }

    @Override
    public boolean hasNext() {
        this.init();
        if (this.jp.isClosed()) {
            return false;
        }
        if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
            CloseQuietly.close((Closeable)this.jp);
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        this.init();
        try {
            Object retVal = this.objectCodec.readValue(this.jp, (ResolvedType)this.typeRef);
            this.jp.nextToken();
            return (T)retVal;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void init() {
        if (this.jp == null) {
            try {
                InputStream is = this.future.get();
                if (this.responseHandler != null && this.responseHandler.getStatus() != 200) {
                    throw new RE("Unexpected response status [%s] description [%s] from request url [%s]", new Object[]{this.responseHandler.getStatus(), this.responseHandler.getDescription(), this.url});
                }
                if (is == null) {
                    throw new QueryInterruptedException((Throwable)new ResourceLimitExceededException("query[%s] url[%s] timed out or max bytes limit reached.", new Object[]{this.query.getId(), this.url}), this.host);
                }
                this.jp = this.objectMapper.getFactory().createParser(is);
                JsonToken nextToken = this.jp.nextToken();
                if (nextToken == JsonToken.START_OBJECT) {
                    QueryInterruptedException cause = (QueryInterruptedException)((Object)this.jp.getCodec().readValue(this.jp, QueryInterruptedException.class));
                    throw new QueryInterruptedException((Throwable)cause, this.host);
                }
                if (nextToken != JsonToken.START_ARRAY) {
                    throw new IAE("Next token wasn't a START_ARRAY, was[%s] from url [%s]", new Object[]{this.jp.getCurrentToken(), this.url});
                }
                this.jp.nextToken();
                this.objectCodec = this.jp.getCodec();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new RE((Throwable)e, "Failure getting results for query[%s] url[%s] because of [%s]", new Object[]{this.query == null ? null : this.query.getId(), this.url, e.getMessage()});
            }
            catch (CancellationException e) {
                throw new QueryInterruptedException((Throwable)e, this.host);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jp != null) {
            this.jp.close();
        }
    }
}

