/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;

public class SegmentLoadInfo {
    private final DataSegment segment;
    private final Set<DruidServerMetadata> servers;

    public SegmentLoadInfo(DataSegment segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        this.segment = segment;
        this.servers = Sets.newConcurrentHashSet();
    }

    public boolean addServer(DruidServerMetadata server) {
        return this.servers.add(server);
    }

    public boolean removeServer(DruidServerMetadata server) {
        return this.servers.remove(server);
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    public ImmutableSegmentLoadInfo toImmutableSegmentLoadInfo() {
        return new ImmutableSegmentLoadInfo(this.segment, this.servers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentLoadInfo that = (SegmentLoadInfo)o;
        if (!this.segment.equals((Object)that.segment)) {
            return false;
        }
        return this.servers.equals(that.servers);
    }

    public int hashCode() {
        int result = this.segment.hashCode();
        result = 31 * result + this.servers.hashCode();
        return result;
    }

    public String toString() {
        return "SegmentLoadInfo{segment=" + this.segment + ", servers=" + this.servers + '}';
    }
}

