/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactQueryTuningConfig;
import org.apache.druid.client.indexing.ClientQuery;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class ClientCompactQuery
implements ClientQuery {
    private final String dataSource;
    private final List<DataSegment> segments;
    private final Interval interval;
    private final boolean keepSegmentGranularity;
    @Nullable
    private final Long targetCompactionSizeBytes;
    private final ClientCompactQueryTuningConfig tuningConfig;
    private final Map<String, Object> context;

    @JsonCreator
    public ClientCompactQuery(@JsonProperty(value="dataSource") String dataSource, @Nullable @JsonProperty(value="interval") Interval interval, @Nullable @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="keepSegmentGranularity") boolean keepSegmentGranularity, @JsonProperty(value="targetCompactionSizeBytes") @Nullable Long targetCompactionSizeBytes, @JsonProperty(value="tuningConfig") ClientCompactQueryTuningConfig tuningConfig, @JsonProperty(value="context") Map<String, Object> context) {
        this.dataSource = dataSource;
        this.segments = segments;
        this.interval = interval;
        this.keepSegmentGranularity = keepSegmentGranularity;
        this.targetCompactionSizeBytes = targetCompactionSizeBytes;
        this.tuningConfig = tuningConfig;
        this.context = context;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "compact";
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public boolean isKeepSegmentGranularity() {
        return this.keepSegmentGranularity;
    }

    @JsonProperty
    @Nullable
    public Long getTargetCompactionSizeBytes() {
        return this.targetCompactionSizeBytes;
    }

    @JsonProperty
    public ClientCompactQueryTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactQuery that = (ClientCompactQuery)o;
        return this.keepSegmentGranularity == that.keepSegmentGranularity && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.segments, that.segments) && Objects.equals(this.interval, that.interval) && Objects.equals(this.targetCompactionSizeBytes, that.targetCompactionSizeBytes) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.segments, this.interval, this.keepSegmentGranularity, this.targetCompactionSizeBytes, this.tuningConfig, this.context);
    }

    public String toString() {
        return "ClientCompactQuery{dataSource='" + this.dataSource + '\'' + ", segments=" + this.segments + ", interval=" + this.interval + ", keepSegmentGranularity=" + this.keepSegmentGranularity + ", targetCompactionSizeBytes=" + this.targetCompactionSizeBytes + ", tuningConfig=" + this.tuningConfig + ", context=" + this.context + '}';
    }
}

