/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;

public class ClientCompactQueryTuningConfig {
    @Nullable
    private final Integer maxRowsPerSegment;
    @Nullable
    private final Integer maxRowsInMemory;
    @Nullable
    private final Integer maxTotalRows;
    @Nullable
    private final IndexSpec indexSpec;
    @Nullable
    private final Integer maxPendingPersists;
    @Nullable
    private final Long pushTimeout;

    public static ClientCompactQueryTuningConfig from(@Nullable DataSourceCompactionConfig.UserCompactTuningConfig userCompactTuningConfig, @Nullable Integer maxRowsPerSegment) {
        return new ClientCompactQueryTuningConfig(maxRowsPerSegment, userCompactTuningConfig == null ? null : userCompactTuningConfig.getMaxRowsInMemory(), userCompactTuningConfig == null ? null : userCompactTuningConfig.getMaxTotalRows(), userCompactTuningConfig == null ? null : userCompactTuningConfig.getIndexSpec(), userCompactTuningConfig == null ? null : userCompactTuningConfig.getMaxPendingPersists(), userCompactTuningConfig == null ? null : userCompactTuningConfig.getPushTimeout());
    }

    @JsonCreator
    public ClientCompactQueryTuningConfig(@JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxTotalRows") @Nullable Integer maxTotalRows, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout) {
        this.maxRowsPerSegment = maxRowsPerSegment;
        this.maxRowsInMemory = maxRowsInMemory;
        this.maxTotalRows = maxTotalRows;
        this.indexSpec = indexSpec;
        this.maxPendingPersists = maxPendingPersists;
        this.pushTimeout = pushTimeout;
    }

    @JsonProperty
    public String getType() {
        return "index";
    }

    @JsonProperty
    @Nullable
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxTotalRows() {
        return this.maxTotalRows;
    }

    @JsonProperty
    @Nullable
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    @Nullable
    public Long getPushTimeout() {
        return this.pushTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactQueryTuningConfig that = (ClientCompactQueryTuningConfig)o;
        return Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.maxRowsInMemory, that.maxRowsInMemory) && Objects.equals(this.maxTotalRows, that.maxTotalRows) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.maxPendingPersists, that.maxPendingPersists) && Objects.equals(this.pushTimeout, that.pushTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.maxRowsPerSegment, this.maxRowsInMemory, this.maxTotalRows, this.indexSpec, this.maxPendingPersists, this.pushTimeout);
    }

    public String toString() {
        return "ClientCompactQueryTuningConfig{maxRowsPerSegment=" + this.maxRowsPerSegment + ", maxRowsInMemory=" + this.maxRowsInMemory + ", maxTotalRows=" + this.maxTotalRows + ", indexSpec=" + this.indexSpec + ", maxPendingPersists=" + this.maxPendingPersists + ", pushTimeout=" + this.pushTimeout + '}';
    }
}

