/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactQuery;
import org.apache.druid.client.indexing.ClientCompactQueryTuningConfig;
import org.apache.druid.client.indexing.ClientKillQuery;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class HttpIndexingServiceClient
implements IndexingServiceClient {
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public HttpIndexingServiceClient(ObjectMapper jsonMapper, @IndexingService DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    @Override
    public void killSegments(String dataSource, Interval interval) {
        this.runTask(new ClientKillQuery(dataSource, interval));
    }

    @Override
    public String compactSegments(List<DataSegment> segments, boolean keepSegmentGranularity, @Nullable Long targetCompactionSizeBytes, int compactionTaskPriority, ClientCompactQueryTuningConfig tuningConfig, @Nullable Map<String, Object> context) {
        Preconditions.checkArgument((segments.size() > 1 ? 1 : 0) != 0, (Object)"Expect two or more segments to compact");
        String dataSource = segments.get(0).getDataSource();
        Preconditions.checkArgument((boolean)segments.stream().allMatch(segment -> segment.getDataSource().equals(dataSource)), (Object)"Segments must have the same dataSource");
        context = context == null ? new HashMap<String, Object>() : context;
        context.put("priority", compactionTaskPriority);
        return this.runTask(new ClientCompactQuery(dataSource, null, segments, keepSegmentGranularity, targetCompactionSizeBytes, tuningConfig, context));
    }

    @Override
    public String runTask(Object taskObject) {
        try {
            FullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/task").setContent("application/json", this.jsonMapper.writeValueAsBytes(taskObject)));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                if (!Strings.isNullOrEmpty((String)response.getContent())) {
                    throw new ISE("Failed to post task[%s] with error[%s].", new Object[]{taskObject, response.getContent()});
                }
                throw new ISE("Failed to post task[%s]. Please check overlord log", new Object[]{taskObject});
            }
            Map resultMap = (Map)this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String taskId = (String)resultMap.get("task");
            return (String)Preconditions.checkNotNull((Object)taskId, (String)"Null task id for task[%s]", (Object[])new Object[]{taskObject});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String killTask(String taskId) {
        try {
            FullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, StringUtils.format((String)"/druid/indexer/v1/task/%s/shutdown", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Failed to kill task[%s]", new Object[]{taskId});
            }
            Map resultMap = (Map)this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String killedTaskId = (String)resultMap.get("task");
            Preconditions.checkNotNull((Object)killedTaskId, (String)"Null task id returned for task[%s]", (Object[])new Object[]{taskId});
            Preconditions.checkState((boolean)taskId.equals(killedTaskId), (String)"Requested to kill task[%s], but another task[%s] was killed!", (Object[])new Object[]{taskId, killedTaskId});
            return killedTaskId;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getTotalWorkerCapacity() {
        try {
            FullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/workers").setHeader("Content-Type", "application/json"));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while getting available cluster capacity. status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            Collection workers = (Collection)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Collection<IndexingWorkerInfo>>(){});
            return workers.stream().mapToInt(workerInfo -> workerInfo.getWorker().getCapacity()).sum();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<TaskStatusPlus> getActiveTasks() {
        ArrayList<TaskStatusPlus> tasks = new ArrayList<TaskStatusPlus>();
        HashSet<String> taskIdsSeen = new HashSet<String>();
        Iterable activeTasks = Iterables.concat(this.getTasks("waitingTasks"), this.getTasks("pendingTasks"), this.getTasks("runningTasks"));
        for (TaskStatusPlus task : activeTasks) {
            if (!taskIdsSeen.add(task.getId())) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private List<TaskStatusPlus> getTasks(String endpointSuffix) {
        try {
            FullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/%s", (Object[])new Object[]{endpointSuffix})));
            if (!responseHolder.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching the status of the last complete task", new Object[0]);
            }
            return (List)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<List<TaskStatusPlus>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TaskStatusResponse getTaskStatus(String taskId) {
        try {
            FullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/task/%s/status", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})));
            return (TaskStatusResponse)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<TaskStatusResponse>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public TaskStatusPlus getLastCompleteTask() {
        List<TaskStatusPlus> completeTaskStatuses = this.getTasks("completeTasks?n=1");
        return completeTaskStatuses.isEmpty() ? null : completeTaskStatuses.get(0);
    }

    @Override
    public TaskPayloadResponse getTaskPayload(String taskId) {
        try {
            FullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/task/%s", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})));
            return (TaskPayloadResponse)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<TaskPayloadResponse>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int killPendingSegments(String dataSource, DateTime end) {
        String endPoint = StringUtils.format((String)"/druid/indexer/v1/pendingSegments/%s?interval=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)end)});
        try {
            FullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.DELETE, endPoint));
            if (!responseHolder.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while killing pendingSegments of dataSource[%s] created until [%s]", new Object[]{dataSource, end});
            }
            Map resultMap = (Map)this.jsonMapper.readValue(responseHolder.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            Object numDeletedObject = resultMap.get("numDeleted");
            return (Integer)Preconditions.checkNotNull(numDeletedObject, (Object)"numDeletedObject");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

