/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import org.apache.curator.RetrySleeper;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.druid.java.util.common.logger.Logger;

public class BoundedExponentialBackoffRetryWithQuit
extends BoundedExponentialBackoffRetry {
    private static final Logger log = new Logger(BoundedExponentialBackoffRetryWithQuit.class);
    private final Runnable exitRunner;

    public BoundedExponentialBackoffRetryWithQuit(Runnable exitRunner, int baseSleepTimeMs, int maxSleepTimeMs, int maxRetries) {
        super(baseSleepTimeMs, maxSleepTimeMs, maxRetries);
        this.exitRunner = exitRunner;
        log.info("BoundedExponentialBackoffRetryWithQuit Retry Policy selected.", new Object[0]);
    }

    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        log.warn("Zookeeper can't be reached, retrying (retryCount = %s out of %s)...", new Object[]{retryCount, this.getN()});
        boolean shouldRetry = super.allowRetry(retryCount, elapsedTimeMs, sleeper);
        if (!shouldRetry) {
            log.warn("Since Zookeeper can't be reached after retries exhausted, calling exit function...", new Object[0]);
            this.exitRunner.run();
        }
        return shouldRetry;
    }
}

