/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.validation.constraints.Min;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.PasswordProvider;

public class CuratorConfig {
    @JsonProperty(value="host")
    private String zkHosts = "localhost";
    @JsonProperty(value="sessionTimeoutMs")
    @Min(value=0L)
    private int zkSessionTimeoutMs = 30000;
    @JsonProperty(value="compress")
    private boolean enableCompression = true;
    @JsonProperty(value="acl")
    private boolean enableAcl = false;
    @JsonProperty(value="user")
    private String zkUser;
    @JsonProperty(value="pwd")
    private PasswordProvider zkPwd = new DefaultPasswordProvider("");
    @JsonProperty(value="authScheme")
    private String authScheme = "digest";
    @JsonProperty(value="terminateDruidProcessOnConnectFail")
    private boolean terminateDruidProcessOnConnectFail = false;

    public String getZkHosts() {
        return this.zkHosts;
    }

    public void setZkHosts(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    public Integer getZkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void setZkSessionTimeoutMs(Integer zkSessionTimeoutMs) {
        this.zkSessionTimeoutMs = zkSessionTimeoutMs;
    }

    public boolean getEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(Boolean enableCompression) {
        Preconditions.checkNotNull((Object)enableCompression, (Object)"enableCompression");
        this.enableCompression = enableCompression;
    }

    public boolean getEnableAcl() {
        return this.enableAcl;
    }

    public void setEnableAcl(Boolean enableAcl) {
        Preconditions.checkNotNull((Object)enableAcl, (Object)"enableAcl");
        this.enableAcl = enableAcl;
    }

    public String getZkUser() {
        return this.zkUser;
    }

    public String getZkPwd() {
        return this.zkPwd.getPassword();
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public boolean getTerminateDruidProcessOnConnectFail() {
        return this.terminateDruidProcessOnConnectFail;
    }

    public void setTerminateDruidProcessOnConnectFail(Boolean terminateDruidProcessOnConnectFail) {
        this.terminateDruidProcessOnConnectFail = terminateDruidProcessOnConnectFail == null ? false : terminateDruidProcessOnConnectFail;
    }
}

