/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.netty.util.SuppressForbidden;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.DefaultExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.Exhibitors;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.shaded.com.google.common.base.Strings;
import org.apache.druid.curator.BoundedExponentialBackoffRetryWithQuit;
import org.apache.druid.curator.CuratorConfig;
import org.apache.druid.curator.ExhibitorConfig;
import org.apache.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class CuratorModule
implements Module {
    static final String CURATOR_CONFIG_PREFIX = "druid.zk.service";
    static final String EXHIBITOR_CONFIG_PREFIX = "druid.exhibitor.service";
    private static final int BASE_SLEEP_TIME_MS = 1000;
    private static final int MAX_SLEEP_TIME_MS = 45000;
    private static final int MAX_RETRIES = 30;
    private static final Logger log = new Logger(CuratorModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)CURATOR_CONFIG_PREFIX, CuratorConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)EXHIBITOR_CONFIG_PREFIX, ExhibitorConfig.class);
    }

    @Provides
    @LazySingleton
    @SuppressForbidden(reason="System#err")
    public CuratorFramework makeCurator(CuratorConfig config, EnsembleProvider ensembleProvider, Lifecycle lifecycle) {
        BoundedExponentialBackoffRetry retryPolicy;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        if (!Strings.isNullOrEmpty((String)config.getZkUser()) && !Strings.isNullOrEmpty((String)config.getZkPwd())) {
            builder.authorization(config.getAuthScheme(), StringUtils.format((String)"%s:%s", (Object[])new Object[]{config.getZkUser(), config.getZkPwd()}).getBytes(StandardCharsets.UTF_8));
        }
        if (config.getTerminateDruidProcessOnConnectFail()) {
            Runnable exitRunner = () -> {
                try {
                    log.error("Zookeeper can't be reached, forcefully stopping lifecycle...", new Object[0]);
                    lifecycle.stop();
                    System.err.println("Zookeeper can't be reached, forcefully stopping virtual machine...");
                }
                finally {
                    System.exit(1);
                }
            };
            retryPolicy = new BoundedExponentialBackoffRetryWithQuit(exitRunner, 1000, 45000, 30);
        } else {
            retryPolicy = new BoundedExponentialBackoffRetry(1000, 45000, 30);
        }
        final CuratorFramework framework = builder.ensembleProvider(ensembleProvider).sessionTimeoutMs(config.getZkSessionTimeoutMs().intValue()).retryPolicy((RetryPolicy)retryPolicy).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(config.getEnableCompression())).aclProvider((ACLProvider)(config.getEnableAcl() ? new SecuredACLProvider() : new DefaultACLProvider())).build();
        framework.getUnhandledErrorListenable().addListener((message, e) -> {
            log.error(e, "Unhandled error in Curator Framework", new Object[0]);
            try {
                lifecycle.stop();
            }
            catch (Throwable t) {
                log.warn(t, "Exception when stopping druid lifecycle", new Object[0]);
            }
        });
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() {
                log.info("Starting Curator", new Object[0]);
                framework.start();
            }

            public void stop() {
                log.info("Stopping Curator", new Object[0]);
                framework.close();
            }
        });
        return framework;
    }

    @Provides
    @LazySingleton
    public EnsembleProvider makeEnsembleProvider(CuratorConfig config, ExhibitorConfig exConfig) {
        BoundedExponentialBackoffRetry retryPolicy;
        if (exConfig.getHosts().isEmpty()) {
            return new FixedEnsembleProvider(config.getZkHosts());
        }
        if (config.getTerminateDruidProcessOnConnectFail()) {
            Runnable exitRunner = () -> {
                try {
                    log.error("Zookeeper can't be reached, forcefully stopping virtual machine...", new Object[0]);
                }
                finally {
                    System.exit(1);
                }
            };
            retryPolicy = new BoundedExponentialBackoffRetryWithQuit(exitRunner, 1000, 45000, 30);
        } else {
            retryPolicy = new BoundedExponentialBackoffRetry(1000, 45000, 30);
        }
        return new ExhibitorEnsembleProvider(new Exhibitors(exConfig.getHosts(), exConfig.getRestPort(), this.newBackupProvider(config.getZkHosts())), (ExhibitorRestClient)new DefaultExhibitorRestClient(exConfig.getUseSsl()), exConfig.getRestUriPath(), exConfig.getPollingMs(), (RetryPolicy)retryPolicy){

            public void start() throws Exception {
                log.info("Poll the list of zookeeper servers for initial ensemble", new Object[0]);
                this.pollForInitialEnsemble();
                super.start();
            }
        };
    }

    private Exhibitors.BackupConnectionStringProvider newBackupProvider(final String zkHosts) {
        return new Exhibitors.BackupConnectionStringProvider(){

            public String getBackupConnectionString() {
                return zkHosts;
            }
        };
    }

    static class SecuredACLProvider
    implements ACLProvider {
        SecuredACLProvider() {
        }

        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

