/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.announcement.Announcer;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.initialization.ZkPathsConfig;

public class CuratorDruidNodeAnnouncer
implements DruidNodeAnnouncer {
    private static final Logger log = new Logger(CuratorDruidNodeAnnouncer.class);
    private final Announcer announcer;
    private final ZkPathsConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public CuratorDruidNodeAnnouncer(Announcer announcer, ZkPathsConfig config, @Json ObjectMapper jsonMapper) {
        this.announcer = announcer;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public void announce(DiscoveryDruidNode discoveryDruidNode) {
        try {
            log.info("Announcing [%s].", new Object[]{discoveryDruidNode});
            String path = ZKPaths.makePath((String)this.config.getInternalDiscoveryPath(), (String)discoveryDruidNode.getNodeType().toString(), (String[])new String[]{discoveryDruidNode.getDruidNode().getHostAndPortToUse()});
            this.announcer.announce(path, this.jsonMapper.writeValueAsBytes((Object)discoveryDruidNode));
            log.info("Announced [%s].", new Object[]{discoveryDruidNode});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unannounce(DiscoveryDruidNode discoveryDruidNode) {
        log.info("Unannouncing [%s].", new Object[]{discoveryDruidNode});
        String path = ZKPaths.makePath((String)this.config.getInternalDiscoveryPath(), (String)discoveryDruidNode.getNodeType().toString(), (String[])new String[]{discoveryDruidNode.getDruidNode().getHostAndPortToUse()});
        this.announcer.unannounce(path);
        log.info("Unannounced [%s].", new Object[]{discoveryDruidNode});
    }
}

