/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.initialization.ZkPathsConfig;

@ManageLifecycle
public class CuratorDruidNodeDiscoveryProvider
extends DruidNodeDiscoveryProvider {
    private static final Logger log = new Logger(CuratorDruidNodeDiscoveryProvider.class);
    private final CuratorFramework curatorFramework;
    private final ZkPathsConfig config;
    private final ObjectMapper jsonMapper;
    private ExecutorService listenerExecutor;
    private final ConcurrentHashMap<NodeType, NodeTypeWatcher> nodeTypeWatchers = new ConcurrentHashMap();
    private final LifecycleLock lifecycleLock = new LifecycleLock();

    @Inject
    public CuratorDruidNodeDiscoveryProvider(CuratorFramework curatorFramework, ZkPathsConfig config, @Json ObjectMapper jsonMapper) {
        this.curatorFramework = curatorFramework;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public DruidNodeDiscovery getForNodeType(NodeType nodeType) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        return this.nodeTypeWatchers.computeIfAbsent(nodeType, nType -> {
            log.info("Creating NodeTypeWatcher for nodeType [%s].", new Object[]{nType});
            NodeTypeWatcher nodeTypeWatcher = new NodeTypeWatcher(this.listenerExecutor, this.curatorFramework, this.config.getInternalDiscoveryPath(), this.jsonMapper, (NodeType)((Object)nType));
            nodeTypeWatcher.start();
            log.info("Created NodeTypeWatcher for nodeType [%s].", new Object[]{nType});
            return nodeTypeWatcher;
        });
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            log.info("starting", new Object[0]);
            this.listenerExecutor = Execs.singleThreaded((String)"CuratorDruidNodeDiscoveryProvider-ListenerExecutor");
            log.info("started", new Object[0]);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        log.info("stopping", new Object[0]);
        for (NodeTypeWatcher watcher : this.nodeTypeWatchers.values()) {
            watcher.stop();
        }
        this.listenerExecutor.shutdownNow();
        log.info("stopped", new Object[0]);
    }

    private static class NodeTypeWatcher
    implements DruidNodeDiscovery {
        private static final Logger log = new Logger(NodeTypeWatcher.class);
        private final CuratorFramework curatorFramework;
        private final NodeType nodeType;
        private final ObjectMapper jsonMapper;
        private final ConcurrentMap<String, DiscoveryDruidNode> nodes = new ConcurrentHashMap<String, DiscoveryDruidNode>();
        private final Collection<DiscoveryDruidNode> unmodifiableNodes = Collections.unmodifiableCollection(this.nodes.values());
        private final PathChildrenCache cache;
        private final ExecutorService cacheExecutor;
        private final ExecutorService listenerExecutor;
        private final List<DruidNodeDiscovery.Listener> nodeListeners = new ArrayList<DruidNodeDiscovery.Listener>();
        private final Object lock = new Object();
        private final CountDownLatch cacheInitialized = new CountDownLatch(1);

        NodeTypeWatcher(ExecutorService listenerExecutor, CuratorFramework curatorFramework, String basePath, ObjectMapper jsonMapper, NodeType nodeType) {
            this.listenerExecutor = listenerExecutor;
            this.curatorFramework = curatorFramework;
            this.nodeType = nodeType;
            this.jsonMapper = jsonMapper;
            this.cacheExecutor = Execs.singleThreaded((String)StringUtils.format((String)"NodeTypeWatcher[%s]", (Object[])new Object[]{nodeType}));
            this.cache = new PathChildrenCache(curatorFramework, ZKPaths.makePath((String)basePath, (String)nodeType.toString()), true, true, this.cacheExecutor);
        }

        @Override
        public Collection<DiscoveryDruidNode> getAllNodes() {
            boolean nodeViewInitialized;
            try {
                nodeViewInitialized = this.cacheInitialized.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                nodeViewInitialized = false;
            }
            if (!nodeViewInitialized) {
                log.info("cache is not initialized yet. getAllNodes() might not return full information.", new Object[0]);
            }
            return this.unmodifiableNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerListener(DruidNodeDiscovery.Listener listener) {
            Object object = this.lock;
            synchronized (object) {
                if (this.cacheInitialized.getCount() == 0L) {
                    this.safeSchedule(() -> {
                        listener.nodesAdded(this.unmodifiableNodes);
                        listener.nodeViewInitialized();
                    }, "Exception occured in nodesAdded([%s]) in listener [%s].", this.unmodifiableNodes, listener);
                }
                this.nodeListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleChildEvent(PathChildrenCacheEvent event) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    switch (event.getType()) {
                        case CHILD_ADDED: {
                            byte[] data;
                            try {
                                data = (byte[])((GetDataWatchBackgroundStatable)this.curatorFramework.getData().decompressed()).forPath(event.getData().getPath());
                            }
                            catch (Exception ex) {
                                log.error((Throwable)ex, "Failed to get data for path [%s]. Ignoring event [%s].", new Object[]{event.getData().getPath(), event.getType()});
                                return;
                            }
                            DiscoveryDruidNode druidNode = (DiscoveryDruidNode)this.jsonMapper.readValue(data, DiscoveryDruidNode.class);
                            if (!this.nodeType.equals((Object)druidNode.getNodeType())) {
                                log.warn("Node[%s:%s] add is discovered by node watcher of different node type. Ignored.", new Object[]{druidNode.getDruidNode().getHostAndPortToUse(), druidNode});
                                return;
                            }
                            log.info("Node[%s:%s] appeared.", new Object[]{druidNode.getDruidNode().getHostAndPortToUse(), druidNode});
                            this.addNode(druidNode);
                            break;
                        }
                        case CHILD_REMOVED: {
                            DiscoveryDruidNode druidNode = (DiscoveryDruidNode)this.jsonMapper.readValue(event.getData().getData(), DiscoveryDruidNode.class);
                            if (!this.nodeType.equals((Object)druidNode.getNodeType())) {
                                log.warn("Node[%s:%s] removal is discovered by node watcher of different type. Ignored.", new Object[]{druidNode.getDruidNode().getHostAndPortToUse(), druidNode});
                                return;
                            }
                            log.info("Node[%s:%s] disappeared.", new Object[]{druidNode.getDruidNode().getHostAndPortToUse(), druidNode});
                            this.removeNode(druidNode);
                            break;
                        }
                        case INITIALIZED: {
                            if (this.cacheInitialized.getCount() == 0L) {
                                log.warn("cache is already initialized. ignoring [%s] event.", new Object[]{event.getType()});
                                return;
                            }
                            log.info("Received INITIALIZED in node watcher.", new Object[0]);
                            for (DruidNodeDiscovery.Listener listener : this.nodeListeners) {
                                this.safeSchedule(() -> {
                                    listener.nodesAdded(this.unmodifiableNodes);
                                    listener.nodeViewInitialized();
                                }, "Exception occured in nodesAdded([%s]) in listener [%s].", this.unmodifiableNodes, listener);
                            }
                            this.cacheInitialized.countDown();
                            break;
                        }
                        default: {
                            log.info("Ignored event type [%s] for nodeType watcher.", new Object[]{event.getType()});
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    log.error((Throwable)ex, "unknown error in node watcher.", new Object[0]);
                }
            }
        }

        private void safeSchedule(Runnable runnable, String errMsgFormat, Object ... args) {
            this.listenerExecutor.submit(() -> {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    log.error(errMsgFormat, args);
                }
            });
        }

        @GuardedBy(value="lock")
        private void addNode(DiscoveryDruidNode druidNode) {
            DiscoveryDruidNode prev = this.nodes.putIfAbsent(druidNode.getDruidNode().getHostAndPortToUse(), druidNode);
            if (prev == null) {
                if (this.cacheInitialized.getCount() == 0L) {
                    ImmutableList newNode = ImmutableList.of((Object)druidNode);
                    for (DruidNodeDiscovery.Listener listener : this.nodeListeners) {
                        this.safeSchedule(() -> NodeTypeWatcher.lambda$addNode$3(listener, (List)newNode), "Exception occured in nodeAdded(node=[%s]) in listener [%s].", druidNode.getDruidNode().getHostAndPortToUse(), listener);
                    }
                }
            } else {
                log.warn("Node[%s:%s] discovered but existed already [%s].", new Object[]{druidNode.getDruidNode().getHostAndPortToUse(), druidNode, prev});
            }
        }

        @GuardedBy(value="lock")
        private void removeNode(DiscoveryDruidNode druidNode) {
            DiscoveryDruidNode prev = (DiscoveryDruidNode)this.nodes.remove(druidNode.getDruidNode().getHostAndPortToUse());
            if (prev == null) {
                log.warn("Noticed disappearance of unknown druid node [%s:%s].", new Object[]{druidNode.getDruidNode().getHostAndPortToUse(), druidNode});
                return;
            }
            if (this.cacheInitialized.getCount() == 0L) {
                ImmutableList nodeRemoved = ImmutableList.of((Object)druidNode);
                for (DruidNodeDiscovery.Listener listener : this.nodeListeners) {
                    this.safeSchedule(() -> NodeTypeWatcher.lambda$removeNode$4(listener, (List)nodeRemoved), "Exception occured in nodeRemoved(node=[%s]) in listener [%s].", druidNode.getDruidNode().getHostAndPortToUse(), listener);
                }
            }
        }

        public void start() {
            try {
                this.cache.getListenable().addListener((client, event) -> this.handleChildEvent(event));
                this.cache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public void stop() {
            try {
                this.cache.close();
                this.cacheExecutor.shutdownNow();
            }
            catch (Exception ex) {
                log.error((Throwable)ex, "Failed to stop node watcher for type [%s].", new Object[]{this.nodeType});
            }
        }

        private static /* synthetic */ void lambda$removeNode$4(DruidNodeDiscovery.Listener listener, List nodeRemoved) {
            listener.nodesRemoved(nodeRemoved);
        }

        private static /* synthetic */ void lambda$addNode$3(DruidNodeDiscovery.Listener listener, List newNode) {
            listener.nodesAdded(newNode);
        }
    }
}

