/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.inventory;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.cache.PathChildrenCacheFactory;
import org.apache.druid.curator.inventory.CuratorInventoryManagerStrategy;
import org.apache.druid.curator.inventory.InventoryManagerConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;

@Deprecated
public class CuratorInventoryManager<ContainerClass, InventoryClass> {
    private static final Logger log = new Logger(CuratorInventoryManager.class);
    private final Object lock = new Object();
    private final CuratorFramework curatorFramework;
    private final InventoryManagerConfig config;
    private final CuratorInventoryManagerStrategy<ContainerClass, InventoryClass> strategy;
    private final ConcurrentMap<String, ContainerHolder> containers;
    private final Set<ContainerHolder> uninitializedInventory;
    private final PathChildrenCacheFactory cacheFactory;
    private final ExecutorService pathChildrenCacheExecutor;
    private volatile PathChildrenCache childrenCache;

    public CuratorInventoryManager(CuratorFramework curatorFramework, InventoryManagerConfig config, ExecutorService exec, CuratorInventoryManagerStrategy<ContainerClass, InventoryClass> strategy) {
        this.curatorFramework = curatorFramework;
        this.config = config;
        this.strategy = strategy;
        this.containers = new ConcurrentHashMap<String, ContainerHolder>();
        this.uninitializedInventory = Sets.newConcurrentHashSet();
        this.pathChildrenCacheExecutor = exec;
        this.cacheFactory = new PathChildrenCacheFactory.Builder().withCacheData(false).withCompressed(true).withExecutorService(this.pathChildrenCacheExecutor).withShutdownExecutorOnClose(false).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.childrenCache != null) {
                return;
            }
            this.childrenCache = this.cacheFactory.make(this.curatorFramework, this.config.getContainerPath());
        }
        this.childrenCache.getListenable().addListener((Object)new ContainerCacheListener());
        try {
            this.childrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        }
        catch (Exception e) {
            Object object2 = this.lock;
            synchronized (object2) {
                try {
                    this.stop();
                }
                catch (IOException e1) {
                    log.error((Throwable)e1, "Exception when stopping InventoryManager that couldn't start.", new Object[0]);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.childrenCache == null) {
                return;
            }
            this.childrenCache.close();
            this.childrenCache = null;
        }
        Closer closer = Closer.create();
        for (ContainerHolder containerHolder : this.containers.values()) {
            closer.register((Closeable)containerHolder.getCache());
        }
        try {
            closer.close();
        }
        finally {
            this.pathChildrenCacheExecutor.shutdown();
        }
    }

    public InventoryManagerConfig getConfig() {
        return this.config;
    }

    public ContainerClass getInventoryValue(String containerKey) {
        ContainerHolder containerHolder = (ContainerHolder)this.containers.get(containerKey);
        return (ContainerClass)(containerHolder == null ? null : containerHolder.getContainer());
    }

    public Collection<ContainerClass> getInventory() {
        return this.containers.values().stream().map(rec$ -> ((ContainerHolder)rec$).getContainer()).collect(Collectors.toList());
    }

    private byte[] getZkDataForNode(String path) {
        try {
            return (byte[])((GetDataWatchBackgroundStatable)this.curatorFramework.getData().decompressed()).forPath(path);
        }
        catch (Exception ex) {
            log.warn((Throwable)ex, "Exception while getting data for node %s", new Object[]{path});
            return null;
        }
    }

    private class ContainerCacheListener
    implements PathChildrenCacheListener {
        private volatile boolean containersInitialized = false;
        private volatile boolean doneInitializing = false;

        private ContainerCacheListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    Object object = CuratorInventoryManager.this.lock;
                    synchronized (object) {
                        ChildData child = event.getData();
                        byte[] data = CuratorInventoryManager.this.getZkDataForNode(child.getPath());
                        if (data == null) {
                            log.info("Ignoring event: Type - %s , Path - %s , Version - %s", new Object[]{event.getType(), child.getPath(), child.getStat().getVersion()});
                            return;
                        }
                        String containerKey = ZKPaths.getNodeFromPath((String)child.getPath());
                        Object container = CuratorInventoryManager.this.strategy.deserializeContainer(data);
                        if (CuratorInventoryManager.this.containers.containsKey(containerKey)) {
                            log.error("New node[%s] but there was already one.  That's not good, ignoring new one.", new Object[]{child.getPath()});
                        } else {
                            String inventoryPath = StringUtils.format((String)"%s/%s", (Object[])new Object[]{CuratorInventoryManager.this.config.getInventoryPath(), containerKey});
                            PathChildrenCache inventoryCache = CuratorInventoryManager.this.cacheFactory.make(CuratorInventoryManager.this.curatorFramework, inventoryPath);
                            inventoryCache.getListenable().addListener((Object)new InventoryCacheListener(containerKey, inventoryPath));
                            CuratorInventoryManager.this.containers.put(containerKey, new ContainerHolder(container, inventoryCache));
                            log.debug("Starting inventory cache for %s, inventoryPath %s", new Object[]{containerKey, inventoryPath});
                            inventoryCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
                            CuratorInventoryManager.this.strategy.newContainer(container);
                        }
                        break;
                    }
                }
                case CHILD_REMOVED: {
                    Object object = CuratorInventoryManager.this.lock;
                    synchronized (object) {
                        ChildData child = event.getData();
                        String containerKey = ZKPaths.getNodeFromPath((String)child.getPath());
                        ContainerHolder removed = (ContainerHolder)CuratorInventoryManager.this.containers.remove(containerKey);
                        if (removed == null) {
                            log.error("Container[%s] removed that wasn't a container!?", new Object[]{child.getPath()});
                            break;
                        }
                        log.debug("Closing inventory cache for %s. Also removing listeners.", new Object[]{containerKey});
                        removed.getCache().getListenable().clear();
                        removed.getCache().close();
                        CuratorInventoryManager.this.strategy.deadContainer(removed.getContainer());
                        ContainerHolder container = removed;
                        synchronized (container) {
                            this.markInventoryInitialized(removed);
                        }
                    }
                }
                case CHILD_UPDATED: {
                    Object object = CuratorInventoryManager.this.lock;
                    synchronized (object) {
                        ChildData child = event.getData();
                        byte[] data = CuratorInventoryManager.this.getZkDataForNode(child.getPath());
                        if (data == null) {
                            log.info("Ignoring event: Type - %s , Path - %s , Version - %s", new Object[]{event.getType(), child.getPath(), child.getStat().getVersion()});
                            return;
                        }
                        String containerKey = ZKPaths.getNodeFromPath((String)child.getPath());
                        Object container = CuratorInventoryManager.this.strategy.deserializeContainer(data);
                        log.debug("Container[%s] updated.", new Object[]{child.getPath()});
                        ContainerHolder holder = (ContainerHolder)CuratorInventoryManager.this.containers.get(containerKey);
                        if (holder == null) {
                            log.error("Container update[%s], but the old container didn't exist!?  Ignoring.", new Object[]{child.getPath()});
                        } else {
                            ContainerHolder containerHolder = holder;
                            synchronized (containerHolder) {
                                holder.setContainer(CuratorInventoryManager.this.strategy.updateContainer(holder.getContainer(), container));
                            }
                        }
                        break;
                    }
                }
                case INITIALIZED: {
                    Object object = CuratorInventoryManager.this.lock;
                    synchronized (object) {
                        Iterator iterator = CuratorInventoryManager.this.containers.values().iterator();
                        while (iterator.hasNext()) {
                            ContainerHolder holder;
                            ContainerHolder containerHolder = holder = (ContainerHolder)iterator.next();
                            synchronized (containerHolder) {
                                if (!holder.initialized) {
                                    CuratorInventoryManager.this.uninitializedInventory.add(holder);
                                }
                            }
                        }
                        this.containersInitialized = true;
                        this.maybeDoneInitializing();
                        break;
                    }
                }
            }
        }

        private void markInventoryInitialized(ContainerHolder holder) {
            holder.initialized = true;
            CuratorInventoryManager.this.uninitializedInventory.remove(holder);
            this.maybeDoneInitializing();
        }

        private void maybeDoneInitializing() {
            if (this.doneInitializing) {
                return;
            }
            if (this.containersInitialized && CuratorInventoryManager.this.uninitializedInventory.isEmpty()) {
                this.doneInitializing = true;
                CuratorInventoryManager.this.strategy.inventoryInitialized();
            }
        }

        private class InventoryCacheListener
        implements PathChildrenCacheListener {
            private final String containerKey;
            private final String inventoryPath;

            public InventoryCacheListener(String containerKey, String inventoryPath) {
                this.containerKey = containerKey;
                this.inventoryPath = inventoryPath;
                log.info("Created new InventoryCacheListener for %s", new Object[]{inventoryPath});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
                ContainerHolder holder = (ContainerHolder)CuratorInventoryManager.this.containers.get(this.containerKey);
                if (holder == null) {
                    return;
                }
                switch (event.getType()) {
                    case CHILD_ADDED: {
                        ChildData child = event.getData();
                        byte[] data = CuratorInventoryManager.this.getZkDataForNode(child.getPath());
                        if (data == null) {
                            log.info("Ignoring event: Type - %s , Path - %s , Version - %s", new Object[]{event.getType(), child.getPath(), child.getStat().getVersion()});
                            return;
                        }
                        String inventoryKey = ZKPaths.getNodeFromPath((String)child.getPath());
                        log.debug("CHILD_ADDED[%s] with version[%s]", new Object[]{child.getPath(), event.getData().getStat().getVersion()});
                        Object addedInventory = CuratorInventoryManager.this.strategy.deserializeInventory(data);
                        ContainerHolder containerHolder = holder;
                        synchronized (containerHolder) {
                            holder.setContainer(CuratorInventoryManager.this.strategy.addInventory(holder.getContainer(), inventoryKey, addedInventory));
                            break;
                        }
                    }
                    case CHILD_UPDATED: {
                        ChildData child = event.getData();
                        byte[] data = CuratorInventoryManager.this.getZkDataForNode(child.getPath());
                        if (data == null) {
                            log.info("Ignoring event: Type - %s , Path - %s , Version - %s", new Object[]{event.getType(), child.getPath(), child.getStat().getVersion()});
                            return;
                        }
                        String inventoryKey = ZKPaths.getNodeFromPath((String)child.getPath());
                        log.debug("CHILD_UPDATED[%s] with version[%s]", new Object[]{child.getPath(), event.getData().getStat().getVersion()});
                        Object updatedInventory = CuratorInventoryManager.this.strategy.deserializeInventory(data);
                        ContainerHolder containerHolder = holder;
                        synchronized (containerHolder) {
                            holder.setContainer(CuratorInventoryManager.this.strategy.updateInventory(holder.getContainer(), inventoryKey, updatedInventory));
                            break;
                        }
                    }
                    case CHILD_REMOVED: {
                        ChildData child = event.getData();
                        String inventoryKey = ZKPaths.getNodeFromPath((String)child.getPath());
                        log.debug("CHILD_REMOVED[%s] with version[%s]", new Object[]{child.getPath(), event.getData().getStat().getVersion()});
                        ContainerHolder containerHolder = holder;
                        synchronized (containerHolder) {
                            holder.setContainer(CuratorInventoryManager.this.strategy.removeInventory(holder.getContainer(), inventoryKey));
                            break;
                        }
                    }
                    case INITIALIZED: {
                        Object object = CuratorInventoryManager.this.lock;
                        synchronized (object) {
                            ContainerHolder containerHolder = holder;
                            synchronized (containerHolder) {
                                ContainerCacheListener.this.markInventoryInitialized(holder);
                            }
                        }
                    }
                }
            }
        }
    }

    private class ContainerHolder {
        private final AtomicReference<ContainerClass> container;
        private final PathChildrenCache cache;
        private boolean initialized = false;

        ContainerHolder(ContainerClass container, PathChildrenCache cache) {
            this.container = new AtomicReference(container);
            this.cache = cache;
        }

        private ContainerClass getContainer() {
            return this.container.get();
        }

        private void setContainer(ContainerClass newContainer) {
            this.container.set(newContainer);
        }

        private PathChildrenCache getCache() {
            return this.cache;
        }
    }
}

