/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.client.DruidServer;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.server.DruidNode;

public class DiscoveryDruidNode {
    private final DruidNode druidNode;
    private final NodeType nodeType;
    private final Map<String, DruidService> services = new HashMap<String, DruidService>();

    @JsonCreator
    public DiscoveryDruidNode(@JsonProperty(value="druidNode") DruidNode druidNode, @JsonProperty(value="nodeType") NodeType nodeType, @JsonProperty(value="services") Map<String, DruidService> services) {
        this.druidNode = druidNode;
        this.nodeType = nodeType;
        if (services != null && !services.isEmpty()) {
            this.services.putAll(services);
        }
    }

    @JsonProperty
    public Map<String, DruidService> getServices() {
        return this.services;
    }

    @JsonProperty
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @JsonProperty
    public DruidNode getDruidNode() {
        return this.druidNode;
    }

    public DruidServer toDruidServer() {
        return new DruidServer(this.getDruidNode().getHostAndPortToUse(), this.getDruidNode().getHostAndPort(), this.getDruidNode().getHostAndTlsPort(), ((DataNodeService)this.getServices().get("dataNodeService")).getMaxSize(), ((DataNodeService)this.getServices().get("dataNodeService")).getType(), ((DataNodeService)this.getServices().get("dataNodeService")).getTier(), ((DataNodeService)this.getServices().get("dataNodeService")).getPriority());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryDruidNode that = (DiscoveryDruidNode)o;
        return Objects.equals(this.druidNode, that.druidNode) && Objects.equals((Object)this.nodeType, (Object)that.nodeType) && Objects.equals(this.services, that.services);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.druidNode, this.nodeType, this.services});
    }

    public String toString() {
        return "DiscoveryDruidNode{druidNode=" + this.druidNode + ", nodeType='" + (Object)((Object)this.nodeType) + '\'' + ", services=" + this.services + '}';
    }
}

