/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.coordinator.CoordinatorSelectorConfig;
import org.apache.druid.curator.discovery.ServerDiscoveryFactory;
import org.apache.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.java.util.http.client.HttpClient;

public class CoordinatorDiscoveryModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.selectors.coordinator", CoordinatorSelectorConfig.class);
    }

    @Provides
    @Coordinator
    @ManageLifecycle
    public ServerDiscoverySelector getServiceProvider(CoordinatorSelectorConfig config, ServerDiscoveryFactory serverDiscoveryFactory) {
        return serverDiscoveryFactory.createSelector(config.getServiceName());
    }

    @Provides
    @Coordinator
    @ManageLifecycle
    public DruidLeaderClient getLeaderHttpClient(@EscalatedGlobal HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, @Coordinator ServerDiscoverySelector serverDiscoverySelector) {
        return new DruidLeaderClient(httpClient, druidNodeDiscoveryProvider, NodeType.COORDINATOR, "/druid/coordinator/v1/leader", serverDiscoverySelector);
    }
}

