/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.druid.client.cache.BackgroundCachePopulator;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.StupidPool;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Processing;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.ExecutorServiceConfig;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.offheap.OffheapBufferGenerator;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.query.MetricsEmittingExecutorService;
import org.apache.druid.query.PrioritizedExecutorService;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.utils.JvmUtils;

public class DruidProcessingModule
implements Module {
    private static final Logger log = new Logger(DruidProcessingModule.class);

    public void configure(Binder binder) {
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @LazySingleton
    public CachePopulator getCachePopulator(@Smile ObjectMapper smileMapper, CachePopulatorStats cachePopulatorStats, CacheConfig cacheConfig) {
        if (cacheConfig.getNumBackgroundThreads() > 0) {
            ExecutorService exec = Executors.newFixedThreadPool(cacheConfig.getNumBackgroundThreads(), new ThreadFactoryBuilder().setNameFormat("background-cacher-%d").setDaemon(true).setPriority(1).build());
            return new BackgroundCachePopulator(exec, smileMapper, cachePopulatorStats, cacheConfig.getMaxEntrySize());
        }
        return new ForegroundCachePopulator(smileMapper, cachePopulatorStats, cacheConfig.getMaxEntrySize());
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(DruidProcessingConfig config, ExecutorServiceMonitor executorServiceMonitor, Lifecycle lifecycle) {
        return new MetricsEmittingExecutorService((ListeningExecutorService)PrioritizedExecutorService.create((Lifecycle)lifecycle, (DruidProcessingConfig)config), executorServiceMonitor);
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new StupidPool("intermediate processing pool", (Supplier)new OffheapBufferGenerator("intermediate processing", config.intermediateComputeSizeBytes()), config.getNumThreads(), config.poolCacheMaxCount());
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new DefaultBlockingPool((Supplier)new OffheapBufferGenerator("result merging", config.intermediateComputeSizeBytes()), config.getNumMergeBuffers());
    }

    private void verifyDirectMemory(DruidProcessingConfig config) {
        try {
            long maxDirectMemory = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
            long memoryNeeded = (long)config.intermediateComputeSizeBytes() * (long)(config.getNumMergeBuffers() + config.getNumThreads() + 1);
            if (maxDirectMemory < memoryNeeded) {
                throw new ProvisionException(StringUtils.format((String)"Not enough direct memory.  Please adjust -XX:MaxDirectMemorySize, druid.processing.buffer.sizeBytes, druid.processing.numThreads, or druid.processing.numMergeBuffers: maxDirectMemory[%,d], memoryNeeded[%,d] = druid.processing.buffer.sizeBytes[%,d] * (druid.processing.numMergeBuffers[%,d] + druid.processing.numThreads[%,d] + 1)", (Object[])new Object[]{maxDirectMemory, memoryNeeded, config.intermediateComputeSizeBytes(), config.getNumMergeBuffers(), config.getNumThreads()}));
            }
        }
        catch (UnsupportedOperationException e) {
            log.info("Could not verify that you have enough direct memory, so I hope you do! Error message was: %s", new Object[]{e.getMessage()});
        }
    }
}

