/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;

public class NoopSupervisorSpec
implements SupervisorSpec {
    @Nullable
    @JsonProperty(value="dataSources")
    private List<String> datasources;
    @Nullable
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="suspended")
    private boolean suspended;

    @VisibleForTesting
    public NoopSupervisorSpec(String id, List<String> datasources) {
        this(id, datasources, null);
    }

    @JsonCreator
    public NoopSupervisorSpec(@Nullable @JsonProperty(value="id") String id, @Nullable @JsonProperty(value="dataSources") List<String> datasources, @Nullable @JsonProperty(value="suspended") Boolean suspended) {
        this.id = id;
        this.datasources = datasources == null ? new ArrayList() : datasources;
        this.suspended = false;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    @JsonProperty(value="dataSources")
    public List<String> getDataSources() {
        return this.datasources;
    }

    @Override
    @JsonProperty(value="suspended")
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public Supervisor createSupervisor() {
        return new Supervisor(){

            @Override
            public void start() {
            }

            @Override
            public void stop(boolean stopGracefully) {
            }

            @Override
            public SupervisorReport getStatus() {
                return null;
            }

            @Override
            public void reset(DataSourceMetadata dataSourceMetadata) {
            }

            @Override
            public void checkpoint(@Nullable Integer taskGroupId, String baseSequenceName, DataSourceMetadata previousCheckPoint, DataSourceMetadata currentCheckPoint) {
            }
        };
    }

    @Override
    public SupervisorSpec createRunningSpec() {
        return new NoopSupervisorSpec(this.id, this.datasources);
    }

    @Override
    public SupervisorSpec createSuspendedSpec() {
        return new NoopSupervisorSpec(this.id, this.datasources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoopSupervisorSpec spec = (NoopSupervisorSpec)o;
        return Objects.equals(this.datasources, spec.datasources) && Objects.equals(this.getId(), spec.getId());
    }

    public int hashCode() {
        return Objects.hash(this.datasources, this.getId());
    }
}

