/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.List;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.query.dimension.LookupDimensionSpec;
import org.apache.druid.query.expression.LookupExprMacro;
import org.apache.druid.query.lookup.LookupConfig;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupIntrospectionResource;
import org.apache.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.druid.query.lookup.LookupListeningResource;
import org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.druid.query.lookup.LookupResourceListenerAnnouncer;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.server.initialization.jetty.JettyBindings;

public class LookupModule
implements DruidModule {
    static final String PROPERTY_BASE = "druid.lookup";
    public static final String FAILED_UPDATES_KEY = "failedUpdates";

    public static String getTierListenerPath(String tier) {
        return ZKPaths.makePath((String)"lookups", (String)tier);
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new SimpleModule("DruidLookupModule").registerSubtypes(new Class[]{MapLookupExtractorFactory.class}), (Object)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(LookupDimensionSpec.class, "lookup"), new NamedType(RegisteredLookupExtractionFn.class, "registeredLookup")}));
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)PROPERTY_BASE, LookupConfig.class);
        binder.bind(LookupExtractorFactoryContainerProvider.class).to(LookupReferencesManager.class);
        LifecycleModule.register((Binder)binder, LookupReferencesManager.class);
        JsonConfigProvider.bind((Binder)binder, (String)PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        Jerseys.addResource((Binder)binder, LookupListeningResource.class);
        Jerseys.addResource((Binder)binder, LookupIntrospectionResource.class);
        ExpressionModule.addExprMacro(binder, LookupExprMacro.class);
        LifecycleModule.register((Binder)binder, LookupResourceListenerAnnouncer.class);
        binder.bind(LookupResourceListenerAnnouncer.class).in(ManageLifecycle.class);
        JettyBindings.addQosFilter(binder, "/druid/listen/v1/lookups", 2);
    }

    @Provides
    @LazySingleton
    public LookupNodeService getLookupNodeService(LookupListeningAnnouncerConfig lookupListeningAnnouncerConfig) {
        return new LookupNodeService(lookupListeningAnnouncerConfig.getLookupTier());
    }
}

