/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.transform.TransformSpec;

public class DataSchema {
    private static final Logger log = new Logger(DataSchema.class);
    private final String dataSource;
    private final Map<String, Object> parser;
    private final AggregatorFactory[] aggregators;
    private final GranularitySpec granularitySpec;
    private final TransformSpec transformSpec;
    private final ObjectMapper jsonMapper;
    private InputRowParser cachedParser;

    @JsonCreator
    public DataSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="parser") Map<String, Object> parser, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="transformSpec") TransformSpec transformSpec, @JacksonInject ObjectMapper jsonMapper) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"null ObjectMapper.");
        this.parser = parser;
        this.transformSpec = transformSpec == null ? TransformSpec.NONE : transformSpec;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataSource) ? 1 : 0) != 0, (Object)"dataSource cannot be null or empty. Please provide a dataSource.");
        Preconditions.checkArgument((!dataSource.contains("/") ? 1 : 0) != 0, (Object)"dataSource cannot contain the '/' character.");
        this.dataSource = dataSource;
        if (granularitySpec == null) {
            log.warn("No granularitySpec has been specified. Using UniformGranularitySpec as default.", new Object[0]);
            this.granularitySpec = new UniformGranularitySpec(null, null, null);
        } else {
            this.granularitySpec = granularitySpec;
        }
        if (aggregators != null && aggregators.length != 0) {
            HashSet<String> names = new HashSet<String>();
            for (AggregatorFactory factory : aggregators) {
                if (names.add(factory.getName())) continue;
                throw new IAE("duplicate aggregators found with name [%s].", new Object[]{factory.getName()});
            }
        } else if (this.granularitySpec.isRollup()) {
            log.warn("No metricsSpec has been specified. Are you sure this is what you want?", new Object[0]);
        }
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="parser")
    public Map<String, Object> getParserMap() {
        return this.parser;
    }

    @JsonIgnore
    public InputRowParser getParser() {
        if (this.parser == null) {
            log.warn("No parser has been specified", new Object[0]);
            return null;
        }
        if (this.cachedParser != null) {
            return this.cachedParser;
        }
        InputRowParser inputRowParser = this.transformSpec.decorate((InputRowParser)this.jsonMapper.convertValue(this.parser, InputRowParser.class));
        HashSet<String> dimensionExclusions = new HashSet<String>();
        for (AggregatorFactory aggregatorFactory : this.aggregators) {
            dimensionExclusions.addAll(aggregatorFactory.requiredFields());
            dimensionExclusions.add(aggregatorFactory.getName());
        }
        if (inputRowParser.getParseSpec() != null) {
            DimensionsSpec dimensionsSpec = inputRowParser.getParseSpec().getDimensionsSpec();
            TimestampSpec timestampSpec = inputRowParser.getParseSpec().getTimestampSpec();
            if (timestampSpec != null) {
                String timestampColumn = timestampSpec.getTimestampColumn();
                if (!dimensionsSpec.hasCustomDimensions() || !dimensionsSpec.getDimensionNames().contains(timestampColumn)) {
                    dimensionExclusions.add(timestampColumn);
                }
            }
            if (dimensionsSpec != null) {
                HashSet<String> metSet = new HashSet<String>();
                for (AggregatorFactory aggregator : this.aggregators) {
                    metSet.add(aggregator.getName());
                }
                HashSet hashSet = Sets.newHashSet((Iterable)dimensionsSpec.getDimensionNames());
                Sets.SetView overlap = Sets.intersection(metSet, (Set)hashSet);
                if (!overlap.isEmpty()) {
                    throw new IAE("Cannot have overlapping dimensions and metrics of the same name. Please change the name of the metric. Overlap: %s", new Object[]{overlap});
                }
                this.cachedParser = inputRowParser.withParseSpec(inputRowParser.getParseSpec().withDimensionsSpec(dimensionsSpec.withDimensionExclusions((Set)Sets.difference(dimensionExclusions, (Set)hashSet))));
            } else {
                this.cachedParser = inputRowParser;
            }
        } else {
            log.warn("No parseSpec in parser has been specified.", new Object[0]);
            this.cachedParser = inputRowParser;
        }
        return this.cachedParser;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    public DataSchema withGranularitySpec(GranularitySpec granularitySpec) {
        return new DataSchema(this.dataSource, this.parser, this.aggregators, granularitySpec, this.transformSpec, this.jsonMapper);
    }

    public DataSchema withTransformSpec(TransformSpec transformSpec) {
        return new DataSchema(this.dataSource, this.parser, this.aggregators, this.granularitySpec, transformSpec, this.jsonMapper);
    }

    public String toString() {
        return "DataSchema{dataSource='" + this.dataSource + '\'' + ", parser=" + this.parser + ", aggregators=" + Arrays.toString(this.aggregators) + ", granularitySpec=" + this.granularitySpec + ", transformSpec=" + this.transformSpec + '}';
    }
}

