/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.FirehoseFactoryV2;
import org.apache.druid.segment.indexing.IOConfig;
import org.apache.druid.segment.realtime.plumber.PlumberSchool;

public class RealtimeIOConfig
implements IOConfig {
    private final FirehoseFactory firehoseFactory;
    private final PlumberSchool plumberSchool;
    private final FirehoseFactoryV2 firehoseFactoryV2;

    @JsonCreator
    public RealtimeIOConfig(@JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="plumber") PlumberSchool plumberSchool, @JsonProperty(value="firehoseV2") FirehoseFactoryV2 firehoseFactoryV2) {
        if (firehoseFactory != null && firehoseFactoryV2 != null) {
            throw new IllegalArgumentException("Only provide one of firehose or firehoseV2");
        }
        this.firehoseFactory = firehoseFactory;
        this.plumberSchool = plumberSchool;
        this.firehoseFactoryV2 = firehoseFactoryV2;
    }

    @JsonProperty(value="firehose")
    public FirehoseFactory getFirehoseFactory() {
        return this.firehoseFactory;
    }

    @JsonProperty(value="firehoseV2")
    public FirehoseFactoryV2 getFirehoseFactoryV2() {
        return this.firehoseFactoryV2;
    }

    public PlumberSchool getPlumberSchool() {
        return this.plumberSchool;
    }
}

