/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import org.apache.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.apache.druid.segment.realtime.plumber.ServerTimeRejectionPolicyFactory;
import org.apache.druid.segment.realtime.plumber.VersioningPolicy;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Period;

public class RealtimeTuningConfig
implements TuningConfig,
AppenderatorConfig {
    private static final int defaultMaxRowsInMemory = 1000000;
    private static final Period defaultIntermediatePersistPeriod = new Period((Object)"PT10M");
    private static final Period defaultWindowPeriod = new Period((Object)"PT10M");
    private static final VersioningPolicy defaultVersioningPolicy = new IntervalStartVersioningPolicy();
    private static final RejectionPolicyFactory defaultRejectionPolicyFactory = new ServerTimeRejectionPolicyFactory();
    private static final int defaultMaxPendingPersists = 0;
    private static final ShardSpec defaultShardSpec = new NumberedShardSpec(0, 1);
    private static final IndexSpec defaultIndexSpec = new IndexSpec();
    private static final Boolean defaultReportParseExceptions = Boolean.FALSE;
    private static final long defaultHandoffConditionTimeout = 0L;
    private static final long defaultAlertTimeout = 0L;
    private static final String defaultDedupColumn = null;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final Period intermediatePersistPeriod;
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final VersioningPolicy versioningPolicy;
    private final RejectionPolicyFactory rejectionPolicyFactory;
    private final int maxPendingPersists;
    private final ShardSpec shardSpec;
    private final IndexSpec indexSpec;
    private final int persistThreadPriority;
    private final int mergeThreadPriority;
    private final boolean reportParseExceptions;
    private final long handoffConditionTimeout;
    private final long alertTimeout;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    @Nullable
    private final String dedupColumn;

    private static File createNewBasePersistDirectory() {
        try {
            return Files.createTempDir();
        }
        catch (IllegalStateException e) {
            String messageTemplate = "Failed to create temporary directory in [%s]! Make sure the `java.io.tmpdir` property is set to an existing and writable directory with enough free space.";
            throw new ISE((Throwable)e, messageTemplate, new Object[]{System.getProperty("java.io.tmpdir")});
        }
    }

    public static RealtimeTuningConfig makeDefaultTuningConfig(@Nullable File basePersistDirectory) {
        return new RealtimeTuningConfig(1000000, 0L, defaultIntermediatePersistPeriod, defaultWindowPeriod, basePersistDirectory == null ? RealtimeTuningConfig.createNewBasePersistDirectory() : basePersistDirectory, defaultVersioningPolicy, defaultRejectionPolicyFactory, 0, defaultShardSpec, defaultIndexSpec, true, 0, 0, defaultReportParseExceptions, 0L, 0L, null, defaultDedupColumn);
    }

    @JsonCreator
    public RealtimeTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="versioningPolicy") VersioningPolicy versioningPolicy, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicyFactory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="shardSpec") ShardSpec shardSpec, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="persistThreadPriority") int persistThreadPriority, @JsonProperty(value="mergeThreadPriority") int mergeThreadPriority, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="alertTimeout") Long alertTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="dedupColumn") @Nullable String dedupColumn) {
        this.maxRowsInMemory = maxRowsInMemory == null ? 1000000 : maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaultIntermediatePersistPeriod : intermediatePersistPeriod;
        this.windowPeriod = windowPeriod == null ? defaultWindowPeriod : windowPeriod;
        this.basePersistDirectory = basePersistDirectory == null ? RealtimeTuningConfig.createNewBasePersistDirectory() : basePersistDirectory;
        this.versioningPolicy = versioningPolicy == null ? defaultVersioningPolicy : versioningPolicy;
        this.rejectionPolicyFactory = rejectionPolicyFactory == null ? defaultRejectionPolicyFactory : rejectionPolicyFactory;
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.shardSpec = shardSpec == null ? defaultShardSpec : shardSpec;
        this.indexSpec = indexSpec == null ? defaultIndexSpec : indexSpec;
        this.mergeThreadPriority = mergeThreadPriority;
        this.persistThreadPriority = persistThreadPriority;
        this.reportParseExceptions = reportParseExceptions == null ? defaultReportParseExceptions : reportParseExceptions;
        this.handoffConditionTimeout = handoffConditionTimeout == null ? 0L : handoffConditionTimeout;
        Preconditions.checkArgument((this.handoffConditionTimeout >= 0L ? 1 : 0) != 0, (Object)"handoffConditionTimeout must be >= 0");
        this.alertTimeout = alertTimeout == null ? 0L : alertTimeout;
        Preconditions.checkArgument((this.alertTimeout >= 0L ? 1 : 0) != 0, (Object)"alertTimeout must be >= 0");
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.dedupColumn = dedupColumn == null ? defaultDedupColumn : dedupColumn;
    }

    @Override
    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @Override
    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @Override
    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @JsonProperty
    public Period getWindowPeriod() {
        return this.windowPeriod;
    }

    @Override
    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    public VersioningPolicy getVersioningPolicy() {
        return this.versioningPolicy;
    }

    @JsonProperty(value="rejectionPolicy")
    public RejectionPolicyFactory getRejectionPolicyFactory() {
        return this.rejectionPolicyFactory;
    }

    @Override
    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @Override
    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Deprecated
    @JsonProperty
    public Boolean getBuildV9Directly() {
        return true;
    }

    @JsonProperty
    public int getPersistThreadPriority() {
        return this.persistThreadPriority;
    }

    @JsonProperty
    public int getMergeThreadPriority() {
        return this.mergeThreadPriority;
    }

    @Override
    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    @JsonProperty
    public long getAlertTimeout() {
        return this.alertTimeout;
    }

    @Override
    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    @JsonProperty
    @Nullable
    public String getDedupColumn() {
        return this.dedupColumn;
    }

    public RealtimeTuningConfig withVersioningPolicy(VersioningPolicy policy) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.maxBytesInMemory, this.intermediatePersistPeriod, this.windowPeriod, this.basePersistDirectory, policy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec, this.indexSpec, true, this.persistThreadPriority, this.mergeThreadPriority, this.reportParseExceptions, this.handoffConditionTimeout, this.alertTimeout, this.segmentWriteOutMediumFactory, this.dedupColumn);
    }

    public RealtimeTuningConfig withBasePersistDirectory(File dir) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.maxBytesInMemory, this.intermediatePersistPeriod, this.windowPeriod, dir, this.versioningPolicy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec, this.indexSpec, true, this.persistThreadPriority, this.mergeThreadPriority, this.reportParseExceptions, this.handoffConditionTimeout, this.alertTimeout, this.segmentWriteOutMediumFactory, this.dedupColumn);
    }
}

