/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class ArbitraryGranularitySpec
implements GranularitySpec {
    private final TreeSet<Interval> intervals;
    private final Granularity queryGranularity;
    private final Boolean rollup;

    @JsonCreator
    public ArbitraryGranularitySpec(@JsonProperty(value="queryGranularity") Granularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="intervals") List<Interval> inputIntervals) {
        this.queryGranularity = queryGranularity == null ? Granularities.NONE : queryGranularity;
        this.rollup = rollup == null ? Boolean.TRUE : rollup;
        this.intervals = new TreeSet(Comparators.intervalsByStartThenEnd());
        if (inputIntervals == null) {
            inputIntervals = new ArrayList<Interval>();
        }
        for (Interval inputInterval : inputIntervals) {
            this.intervals.add(inputInterval);
        }
        PeekingIterator intervalIterator = Iterators.peekingIterator(this.intervals.iterator());
        while (intervalIterator.hasNext()) {
            Interval nextInterval;
            Interval currentInterval = (Interval)intervalIterator.next();
            if (!intervalIterator.hasNext() || !currentInterval.overlaps((ReadableInterval)(nextInterval = (Interval)intervalIterator.peek()))) continue;
            throw new IAE("Overlapping intervals: %s, %s", new Object[]{currentInterval, nextInterval});
        }
    }

    public ArbitraryGranularitySpec(Granularity queryGranularity, List<Interval> inputIntervals) {
        this(queryGranularity, true, inputIntervals);
    }

    @Override
    @JsonProperty(value="intervals")
    public Optional<SortedSet<Interval>> bucketIntervals() {
        return Optional.of(this.intervals);
    }

    @Override
    public List<Interval> inputIntervals() {
        return ImmutableList.copyOf(this.intervals);
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        Interval interval = this.intervals.floor(new Interval((ReadableInstant)dt, (ReadableInstant)DateTimes.MAX));
        if (interval != null && interval.contains((ReadableInstant)dt)) {
            return Optional.of((Object)interval);
        }
        return Optional.absent();
    }

    @Override
    public Granularity getSegmentGranularity() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="rollup")
    public boolean isRollup() {
        return this.rollup;
    }

    @Override
    @JsonProperty(value="queryGranularity")
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArbitraryGranularitySpec that = (ArbitraryGranularitySpec)o;
        if (!this.intervals.equals(that.intervals)) {
            return false;
        }
        if (!this.rollup.equals(that.rollup)) {
            return false;
        }
        return !(this.queryGranularity == null ? that.queryGranularity != null : !this.queryGranularity.equals(that.queryGranularity));
    }

    public int hashCode() {
        int result = this.intervals.hashCode();
        result = 31 * result + this.rollup.hashCode();
        result = 31 * result + (this.queryGranularity != null ? this.queryGranularity.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ArbitraryGranularitySpec{intervals=" + this.intervals + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + '}';
    }

    @Override
    public GranularitySpec withIntervals(List<Interval> inputIntervals) {
        return new ArbitraryGranularitySpec(this.queryGranularity, this.rollup, inputIntervals);
    }
}

