/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public class LocalDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(LocalDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final File storageDirectory;

    @Inject
    public LocalDataSegmentKiller(LocalDataSegmentPusherConfig config) {
        this.storageDirectory = config.getStorageDirectory();
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        block4: {
            File path = this.getPath(segment);
            log.info("killing segment[%s] mapped to path[%s]", new Object[]{segment.getId(), path});
            try {
                if (path.getName().endsWith(".zip")) {
                    File parentDir = path.getParentFile();
                    FileUtils.deleteDirectory((File)parentDir);
                    int maxDepth = 4;
                    for (parentDir = parentDir.getParentFile(); parentDir != null && --maxDepth >= 0 && parentDir.delete() && !segment.getDataSource().equals(parentDir.getName()); parentDir = parentDir.getParentFile()) {
                    }
                    break block4;
                }
                throw new SegmentLoadingException("Unknown file type[%s]", new Object[]{path});
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to kill segment", new Object[0]);
            }
        }
    }

    public void killAll() throws IOException {
        log.info("Deleting all segment files from local dir [%s].", new Object[]{this.storageDirectory.getAbsolutePath()});
        FileUtils.deleteDirectory((File)this.storageDirectory);
    }

    private File getPath(DataSegment segment) {
        return new File(MapUtils.getString((Map)segment.getLoadSpec(), (String)PATH_KEY));
    }
}

