/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.utils.JvmUtils;
import org.hibernate.validator.constraints.NotEmpty;

public class SegmentLoaderConfig {
    @JsonProperty
    @NotEmpty
    private List<StorageLocationConfig> locations = null;
    @JsonProperty(value="deleteOnRemove")
    private boolean deleteOnRemove = true;
    @JsonProperty(value="dropSegmentDelayMillis")
    private int dropSegmentDelayMillis = (int)TimeUnit.SECONDS.toMillis(30L);
    @JsonProperty(value="announceIntervalMillis")
    private int announceIntervalMillis = 0;
    @JsonProperty(value="numLoadingThreads")
    private int numLoadingThreads = JvmUtils.getRuntimeInfo().getAvailableProcessors();
    @JsonProperty(value="numBootstrapThreads")
    private Integer numBootstrapThreads = null;
    @JsonProperty
    private File infoDir = null;
    @JsonProperty
    private int statusQueueMaxSize = 100;

    public List<StorageLocationConfig> getLocations() {
        return this.locations;
    }

    public boolean isDeleteOnRemove() {
        return this.deleteOnRemove;
    }

    public int getDropSegmentDelayMillis() {
        return this.dropSegmentDelayMillis;
    }

    public int getAnnounceIntervalMillis() {
        return this.announceIntervalMillis;
    }

    public int getNumLoadingThreads() {
        return this.numLoadingThreads;
    }

    public int getNumBootstrapThreads() {
        return this.numBootstrapThreads == null ? this.numLoadingThreads : this.numBootstrapThreads;
    }

    public File getInfoDir() {
        if (this.infoDir == null) {
            if (this.locations == null || this.locations.size() == 0) {
                throw new ISE("You have no segment cache locations defined. Please configure druid.segmentCache.locations to use one or more locations.", new Object[0]);
            }
            this.infoDir = new File(this.locations.get(0).getPath(), "info_dir");
        }
        return this.infoDir;
    }

    public int getStatusQueueMaxSize() {
        return this.statusQueueMaxSize;
    }

    public SegmentLoaderConfig withLocations(List<StorageLocationConfig> locations) {
        SegmentLoaderConfig retVal = new SegmentLoaderConfig();
        retVal.locations = Lists.newArrayList(locations);
        retVal.deleteOnRemove = this.deleteOnRemove;
        retVal.infoDir = this.infoDir;
        return retVal;
    }

    public String toString() {
        return "SegmentLoaderConfig{locations=" + this.locations + ", deleteOnRemove=" + this.deleteOnRemove + ", dropSegmentDelayMillis=" + this.dropSegmentDelayMillis + ", infoDir=" + this.infoDir + '}';
    }
}

