/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.DataSegment;

class StorageLocation {
    private static final Logger log = new Logger(StorageLocation.class);
    private final File path;
    private final long maxSize;
    private final long freeSpaceToKeep;
    private final Set<DataSegment> segments;
    private volatile long currSize = 0L;

    StorageLocation(File path, long maxSize, @Nullable Double freeSpacePercent) {
        this.path = path;
        this.maxSize = maxSize;
        if (freeSpacePercent != null) {
            long totalSpaceInPartition = path.getTotalSpace();
            this.freeSpaceToKeep = (long)(freeSpacePercent * (double)totalSpaceInPartition / 100.0);
            log.info("SegmentLocation[%s] will try and maintain [%d:%d] free space while loading segments.", new Object[]{path, this.freeSpaceToKeep, totalSpaceInPartition});
        } else {
            this.freeSpaceToKeep = 0L;
        }
        this.segments = new HashSet<DataSegment>();
    }

    File getPath() {
        return this.path;
    }

    long getMaxSize() {
        return this.maxSize;
    }

    synchronized void addSegment(DataSegment segment) {
        if (this.segments.add(segment)) {
            this.currSize += segment.getSize();
        }
    }

    synchronized void removeSegment(DataSegment segment) {
        if (this.segments.remove(segment)) {
            this.currSize -= segment.getSize();
        }
    }

    boolean canHandle(DataSegment segment) {
        if (this.available() < segment.getSize()) {
            log.warn("Segment[%s:%,d] too large for storage[%s:%,d]. Check your druid.segmentCache.locations maxSize param", new Object[]{segment.getId(), segment.getSize(), this.getPath(), this.available()});
            return false;
        }
        if (this.freeSpaceToKeep > 0L) {
            long currFreeSpace = this.path.getFreeSpace();
            if (this.freeSpaceToKeep + segment.getSize() > currFreeSpace) {
                log.warn("Segment[%s:%,d] too large for storage[%s:%,d] to maintain suggested freeSpace[%d], current freeSpace is [%d].", new Object[]{segment.getId(), segment.getSize(), this.getPath(), this.available(), this.freeSpaceToKeep, currFreeSpace});
                return false;
            }
        }
        return true;
    }

    synchronized long available() {
        return this.maxSize - this.currSize;
    }
}

