/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseV2;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.RealtimeIOConfig;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.plumber.Plumber;

public class FireDepartment
extends IngestionSpec<RealtimeIOConfig, RealtimeTuningConfig> {
    private final DataSchema dataSchema;
    private final RealtimeIOConfig ioConfig;
    private final RealtimeTuningConfig tuningConfig;
    private final FireDepartmentMetrics metrics = new FireDepartmentMetrics();

    @JsonCreator
    public FireDepartment(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") RealtimeIOConfig ioConfig, @JsonProperty(value="tuningConfig") RealtimeTuningConfig tuningConfig) {
        super(dataSchema, ioConfig, tuningConfig);
        Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        Preconditions.checkNotNull((Object)ioConfig, (Object)"ioConfig");
        this.dataSchema = dataSchema;
        this.ioConfig = ioConfig;
        this.tuningConfig = tuningConfig == null ? RealtimeTuningConfig.makeDefaultTuningConfig(null) : tuningConfig;
    }

    @Override
    @JsonProperty(value="dataSchema")
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @Override
    @JsonProperty(value="ioConfig")
    public RealtimeIOConfig getIOConfig() {
        return this.ioConfig;
    }

    @Override
    @JsonProperty(value="tuningConfig")
    public RealtimeTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public Plumber findPlumber() {
        return this.ioConfig.getPlumberSchool().findPlumber(this.dataSchema, this.tuningConfig, this.metrics);
    }

    public boolean checkFirehoseV2() {
        return this.ioConfig.getFirehoseFactoryV2() != null;
    }

    public Firehose connect() throws IOException {
        return this.ioConfig.getFirehoseFactory().connect(this.dataSchema.getParser(), null);
    }

    public FirehoseV2 connect(Object metaData) throws IOException {
        return this.ioConfig.getFirehoseFactoryV2().connect(this.dataSchema.getParser(), metaData);
    }

    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }
}

