/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Committer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import org.apache.druid.segment.realtime.appenderator.AppenderatorDriverMetadata;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.druid.segment.realtime.appenderator.SegmentWithState;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class BaseAppenderatorDriver
implements Closeable {
    private static final Logger log = new Logger(BaseAppenderatorDriver.class);
    private final SegmentAllocator segmentAllocator;
    private final UsedSegmentChecker usedSegmentChecker;
    private final DataSegmentKiller dataSegmentKiller;
    protected final Appenderator appenderator;
    protected final Map<String, SegmentsForSequence> segments = new TreeMap<String, SegmentsForSequence>();
    protected final ListeningExecutorService executor;

    BaseAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, UsedSegmentChecker usedSegmentChecker, DataSegmentKiller dataSegmentKiller) {
        this.appenderator = (Appenderator)Preconditions.checkNotNull((Object)appenderator, (Object)"appenderator");
        this.segmentAllocator = (SegmentAllocator)Preconditions.checkNotNull((Object)segmentAllocator, (Object)"segmentAllocator");
        this.usedSegmentChecker = (UsedSegmentChecker)Preconditions.checkNotNull((Object)usedSegmentChecker, (Object)"usedSegmentChecker");
        this.dataSegmentKiller = (DataSegmentKiller)Preconditions.checkNotNull((Object)dataSegmentKiller, (Object)"dataSegmentKiller");
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"publish-%d"));
    }

    @VisibleForTesting
    Map<String, SegmentsForSequence> getSegments() {
        return this.segments;
    }

    @Nullable
    public abstract Object startJob();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdWithShardSpec getAppendableSegment(DateTime timestamp, String sequenceName) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            SegmentsForSequence segmentsForSequence = this.segments.get(sequenceName);
            if (segmentsForSequence == null) {
                return null;
            }
            Map.Entry<Long, SegmentsOfInterval> candidateEntry = segmentsForSequence.floor(timestamp.getMillis());
            if (candidateEntry != null) {
                SegmentsOfInterval segmentsOfInterval = candidateEntry.getValue();
                if (segmentsOfInterval.interval.contains((ReadableInstant)timestamp)) {
                    return segmentsOfInterval.appendingSegment == null ? null : segmentsOfInterval.appendingSegment.getSegmentIdentifier();
                }
                return null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdWithShardSpec getSegment(InputRow row, String sequenceName, boolean skipSegmentLineageCheck) throws IOException {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            DateTime timestamp = row.getTimestamp();
            SegmentIdWithShardSpec existing = this.getAppendableSegment(timestamp, sequenceName);
            if (existing != null) {
                return existing;
            }
            SegmentsForSequence segmentsForSequence = this.segments.get(sequenceName);
            SegmentIdWithShardSpec newSegment = this.segmentAllocator.allocate(row, sequenceName, segmentsForSequence == null ? null : segmentsForSequence.lastSegmentId, skipSegmentLineageCheck);
            if (newSegment != null) {
                for (SegmentIdWithShardSpec identifier : this.appenderator.getSegments()) {
                    if (!identifier.equals(newSegment)) continue;
                    throw new ISE("WTF?! Allocated segment[%s] which conflicts with existing segment[%s].", new Object[]{newSegment, identifier});
                }
                log.info("New segment[%s] for row[%s] sequenceName[%s].", new Object[]{newSegment, row, sequenceName});
                this.addSegment(sequenceName, newSegment);
            } else {
                log.warn("Cannot allocate segment for timestamp[%s], sequenceName[%s]. ", new Object[]{timestamp, sequenceName});
            }
            return newSegment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSegment(String sequenceName, SegmentIdWithShardSpec identifier) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            this.segments.computeIfAbsent(sequenceName, k -> new SegmentsForSequence()).add(identifier);
        }
    }

    protected AppenderatorDriverAddResult append(InputRow row, String sequenceName, @Nullable Supplier<Committer> committerSupplier, boolean skipSegmentLineageCheck, boolean allowIncrementalPersists) throws IOException {
        Preconditions.checkNotNull((Object)row, (Object)"row");
        Preconditions.checkNotNull((Object)sequenceName, (Object)"sequenceName");
        SegmentIdWithShardSpec identifier = this.getSegment(row, sequenceName, skipSegmentLineageCheck);
        if (identifier != null) {
            try {
                Appenderator.AppenderatorAddResult result = this.appenderator.add(identifier, row, committerSupplier == null ? null : this.wrapCommitterSupplier(committerSupplier), allowIncrementalPersists);
                return AppenderatorDriverAddResult.ok(identifier, result.getNumRowsInSegment(), this.appenderator.getTotalRowCount(), result.isPersistRequired(), result.getParseException());
            }
            catch (SegmentNotWritableException e) {
                throw new ISE((Throwable)e, "WTF?! Segment[%s] not writable when it should have been.", new Object[]{identifier});
            }
        }
        return AppenderatorDriverAddResult.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<SegmentWithState> getSegmentWithStates(Collection<String> sequenceNames) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            return sequenceNames.stream().map(this.segments::get).filter(Objects::nonNull).flatMap(segmentsForSequence -> ((SegmentsForSequence)segmentsForSequence).intervalToSegmentStates.values().stream()).flatMap(segmentsOfInterval -> segmentsOfInterval.getAllSegments().stream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<SegmentWithState> getAppendingSegments(Collection<String> sequenceNames) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            return sequenceNames.stream().map(this.segments::get).filter(Objects::nonNull).flatMap(segmentsForSequence -> ((SegmentsForSequence)segmentsForSequence).intervalToSegmentStates.values().stream()).map(segmentsOfInterval -> ((SegmentsOfInterval)segmentsOfInterval).appendingSegment).filter(Objects::nonNull);
        }
    }

    ListenableFuture<SegmentsAndMetadata> pushInBackground(@Nullable WrappedCommitter wrappedCommitter, Collection<SegmentIdWithShardSpec> segmentIdentifiers, boolean useUniquePath) {
        log.info("Pushing segments in background: [%s]", new Object[]{Joiner.on((String)", ").join(segmentIdentifiers)});
        return Futures.transform(this.appenderator.push(segmentIdentifiers, wrappedCommitter, useUniquePath), segmentsAndMetadata -> {
            Set pushedSegments = segmentsAndMetadata.getSegments().stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toSet());
            if (!pushedSegments.equals(Sets.newHashSet((Iterable)segmentIdentifiers))) {
                log.warn("Removing segments from deep storage because sanity check failed: %s", new Object[]{segmentsAndMetadata.getSegments()});
                segmentsAndMetadata.getSegments().forEach(arg_0 -> ((DataSegmentKiller)this.dataSegmentKiller).killQuietly(arg_0));
                throw new ISE("WTF?! Pushed different segments than requested. Pushed[%s], requested[%s].", new Object[]{pushedSegments, segmentIdentifiers});
            }
            return segmentsAndMetadata;
        }, (Executor)this.executor);
    }

    ListenableFuture<SegmentsAndMetadata> dropInBackground(SegmentsAndMetadata segmentsAndMetadata) {
        log.info("Dropping segments[%s]", new Object[]{segmentsAndMetadata.getSegments()});
        ListenableFuture dropFuture = Futures.allAsList((Iterable)segmentsAndMetadata.getSegments().stream().map(segment -> this.appenderator.drop(SegmentIdWithShardSpec.fromDataSegment(segment))).collect(Collectors.toList()));
        return Futures.transform((ListenableFuture)dropFuture, x -> {
            Object metadata = segmentsAndMetadata.getCommitMetadata();
            return new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), metadata == null ? null : ((AppenderatorDriverMetadata)metadata).getCallerMetadata());
        });
    }

    ListenableFuture<SegmentsAndMetadata> publishInBackground(SegmentsAndMetadata segmentsAndMetadata, TransactionalSegmentPublisher publisher) {
        return this.executor.submit(() -> {
            block8: {
                if (segmentsAndMetadata.getSegments().isEmpty()) {
                    log.info("Nothing to publish, skipping publish step.", new Object[0]);
                } else {
                    log.info("Publishing segments with commitMetadata[%s]: [%s]", new Object[]{segmentsAndMetadata.getCommitMetadata(), Joiner.on((String)", ").join(segmentsAndMetadata.getSegments())});
                    try {
                        Object metadata = segmentsAndMetadata.getCommitMetadata();
                        ImmutableSet ourSegments = ImmutableSet.copyOf(segmentsAndMetadata.getSegments());
                        SegmentPublishResult publishResult = publisher.publishSegments((Set<DataSegment>)ourSegments, metadata == null ? null : ((AppenderatorDriverMetadata)metadata).getCallerMetadata());
                        if (publishResult.isSuccess()) {
                            log.info("Published segments.", new Object[0]);
                            break block8;
                        }
                        Set<SegmentIdWithShardSpec> segmentsIdentifiers = segmentsAndMetadata.getSegments().stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toSet());
                        Set<DataSegment> activeSegments = this.usedSegmentChecker.findUsedSegments(segmentsIdentifiers);
                        if (activeSegments.equals(ourSegments)) {
                            log.info("Could not publish segments, but checked and found them already published. Continuing.", new Object[0]);
                            boolean physicallyDisjoint = Sets.intersection(activeSegments.stream().map(DataSegment::getLoadSpec).collect(Collectors.toSet()), ourSegments.stream().map(DataSegment::getLoadSpec).collect(Collectors.toSet())).isEmpty();
                            if (physicallyDisjoint) {
                                segmentsAndMetadata.getSegments().forEach(arg_0 -> ((DataSegmentKiller)this.dataSegmentKiller).killQuietly(arg_0));
                            }
                            break block8;
                        }
                        segmentsAndMetadata.getSegments().forEach(arg_0 -> ((DataSegmentKiller)this.dataSegmentKiller).killQuietly(arg_0));
                        if (publishResult.getErrorMsg() != null) {
                            throw new ISE("Failed to publish segments because of [%s].", new Object[]{publishResult.getErrorMsg()});
                        }
                        throw new ISE("Failed to publish segments.", new Object[0]);
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Failed publish, not removing segments: %s", new Object[]{segmentsAndMetadata.getSegments()});
                        Throwables.propagateIfPossible((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
            return segmentsAndMetadata;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void clear() throws InterruptedException {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            this.segments.clear();
        }
        this.appenderator.clear();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WrappedCommitter wrapCommitter(Committer committer) {
        ImmutableMap snapshot;
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            snapshot = ImmutableMap.copyOf(this.segments);
        }
        AppenderatorDriverMetadata wrappedMetadata = new AppenderatorDriverMetadata((Map<String, List<SegmentWithState>>)ImmutableMap.copyOf((Map)Maps.transformValues((Map)snapshot, input -> ImmutableList.copyOf((Collection)((SegmentsForSequence)input).intervalToSegmentStates.values().stream().flatMap(segmentsOfInterval -> segmentsOfInterval.getAllSegments().stream()).collect(Collectors.toList())))), snapshot.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SegmentsForSequence)e.getValue()).lastSegmentId)), committer.getMetadata());
        return new WrappedCommitter(committer, wrappedMetadata);
    }

    private Supplier<Committer> wrapCommitterSupplier(Supplier<Committer> committerSupplier) {
        return () -> this.wrapCommitter((Committer)committerSupplier.get());
    }

    static class WrappedCommitter
    implements Committer {
        private final Committer delegate;
        private final AppenderatorDriverMetadata metadata;

        WrappedCommitter(Committer delegate, AppenderatorDriverMetadata metadata) {
            this.delegate = delegate;
            this.metadata = metadata;
        }

        public Object getMetadata() {
            return this.metadata;
        }

        public void run() {
            this.delegate.run();
        }
    }

    static class SegmentsForSequence {
        private final NavigableMap<Long, SegmentsOfInterval> intervalToSegmentStates;
        private String lastSegmentId;

        SegmentsForSequence() {
            this.intervalToSegmentStates = new TreeMap<Long, SegmentsOfInterval>();
        }

        SegmentsForSequence(NavigableMap<Long, SegmentsOfInterval> intervalToSegmentStates, String lastSegmentId) {
            this.intervalToSegmentStates = intervalToSegmentStates;
            this.lastSegmentId = lastSegmentId;
        }

        void add(SegmentIdWithShardSpec identifier) {
            this.intervalToSegmentStates.computeIfAbsent(identifier.getInterval().getStartMillis(), k -> new SegmentsOfInterval(identifier.getInterval())).setAppendingSegment(SegmentWithState.newSegment(identifier));
            this.lastSegmentId = identifier.toString();
        }

        Map.Entry<Long, SegmentsOfInterval> floor(long timestamp) {
            return this.intervalToSegmentStates.floorEntry(timestamp);
        }

        SegmentsOfInterval get(long timestamp) {
            return (SegmentsOfInterval)this.intervalToSegmentStates.get(timestamp);
        }

        Stream<SegmentWithState> allSegmentStateStream() {
            return this.intervalToSegmentStates.values().stream().flatMap(segmentsOfInterval -> segmentsOfInterval.getAllSegments().stream());
        }

        Stream<SegmentsOfInterval> getAllSegmentsOfInterval() {
            return this.intervalToSegmentStates.values().stream();
        }
    }

    static class SegmentsOfInterval {
        private final Interval interval;
        private final List<SegmentWithState> appendFinishedSegments = new ArrayList<SegmentWithState>();
        @Nullable
        private SegmentWithState appendingSegment;

        SegmentsOfInterval(Interval interval) {
            this.interval = interval;
        }

        SegmentsOfInterval(Interval interval, @Nullable SegmentWithState appendingSegment, List<SegmentWithState> appendFinishedSegments) {
            this.interval = interval;
            this.appendingSegment = appendingSegment;
            this.appendFinishedSegments.addAll(appendFinishedSegments);
            if (appendingSegment != null) {
                Preconditions.checkArgument((appendingSegment.getState() == SegmentWithState.SegmentState.APPENDING ? 1 : 0) != 0, (String)"appendingSegment[%s] is not in the APPENDING state", (Object[])new Object[]{appendingSegment.getSegmentIdentifier()});
            }
            if (appendFinishedSegments.stream().anyMatch(segmentWithState -> segmentWithState.getState() == SegmentWithState.SegmentState.APPENDING)) {
                throw new ISE("Some appendFinishedSegments[%s] is in the APPENDING state", new Object[]{appendFinishedSegments});
            }
        }

        void setAppendingSegment(SegmentWithState appendingSegment) {
            Preconditions.checkArgument((appendingSegment.getState() == SegmentWithState.SegmentState.APPENDING ? 1 : 0) != 0, (String)"segment[%s] is not in the APPENDING state", (Object[])new Object[]{appendingSegment.getSegmentIdentifier()});
            Preconditions.checkState((this.appendingSegment == null ? 1 : 0) != 0, (String)"WTF?! Current appendingSegment[%s] is not null. Its state must be changed before setting a new appendingSegment[%s]", (Object[])new Object[]{this.appendingSegment, appendingSegment});
            this.appendingSegment = appendingSegment;
        }

        void finishAppendingToCurrentActiveSegment(Consumer<SegmentWithState> stateTransitionFn) {
            Preconditions.checkNotNull((Object)this.appendingSegment, (Object)"appendingSegment");
            stateTransitionFn.accept(this.appendingSegment);
            this.appendFinishedSegments.add(this.appendingSegment);
            this.appendingSegment = null;
        }

        Interval getInterval() {
            return this.interval;
        }

        SegmentWithState getAppendingSegment() {
            return this.appendingSegment;
        }

        List<SegmentWithState> getAllSegments() {
            ArrayList<SegmentWithState> allSegments = new ArrayList<SegmentWithState>(this.appendFinishedSegments.size() + 1);
            if (this.appendingSegment != null) {
                allSegments.add(this.appendingSegment);
            }
            allSegments.addAll(this.appendFinishedSegments);
            return allSegments;
        }
    }
}

