/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.prefetch.PrefetchableTextFilesFirehoseFactory;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.utils.CompressionUtils;

public class HttpFirehoseFactory
extends PrefetchableTextFilesFirehoseFactory<URI> {
    private static final Logger log = new Logger(HttpFirehoseFactory.class);
    private final List<URI> uris;
    private final boolean supportContentRange;
    @Nullable
    private final String httpAuthenticationUsername;
    @Nullable
    private final PasswordProvider httpAuthenticationPasswordProvider;

    @JsonCreator
    public HttpFirehoseFactory(@JsonProperty(value="uris") List<URI> uris, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="maxFetchRetry") Integer maxFetchRetry, @Nullable @JsonProperty(value="httpAuthenticationUsername") String httpAuthenticationUsername, @Nullable @JsonProperty(value="httpAuthenticationPassword") PasswordProvider httpAuthenticationPasswordProvider) throws IOException {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        this.uris = uris;
        Preconditions.checkArgument((uris.size() > 0 ? 1 : 0) != 0, (Object)"Empty URIs");
        URLConnection connection = uris.get(0).toURL().openConnection();
        String acceptRanges = connection.getHeaderField("Accept-Ranges");
        this.supportContentRange = acceptRanges != null && "bytes".equalsIgnoreCase(acceptRanges);
        this.httpAuthenticationUsername = httpAuthenticationUsername;
        this.httpAuthenticationPasswordProvider = httpAuthenticationPasswordProvider;
    }

    @JsonProperty
    public String getHttpAuthenticationUsername() {
        return this.httpAuthenticationUsername;
    }

    @JsonProperty(value="httpAuthenticationPassword")
    public PasswordProvider getHttpAuthenticationPasswordProvider() {
        return this.httpAuthenticationPasswordProvider;
    }

    @JsonProperty
    public List<URI> getUris() {
        return this.uris;
    }

    protected Collection<URI> initObjects() {
        return this.uris;
    }

    protected InputStream openObjectStream(URI object) throws IOException {
        return this.openObjectStream(object, 0L);
    }

    protected InputStream openObjectStream(URI object, long start) throws IOException {
        URLConnection urlConnection = this.openURLConnection(object);
        if (this.supportContentRange && start > 0L) {
            urlConnection.addRequestProperty("Range", StringUtils.format((String)"bytes=%d-", (Object[])new Object[]{start}));
            return urlConnection.getInputStream();
        }
        if (!this.supportContentRange && start > 0L) {
            log.warn("Since the input source doesn't support range requests, the object input stream is opened from the start and then skipped. This may make the ingestion speed slower. Consider enabling prefetch if you see this message a lot.", new Object[0]);
        }
        InputStream in = urlConnection.getInputStream();
        in.skip(start);
        return in;
    }

    protected InputStream wrapObjectStream(URI object, InputStream stream) throws IOException {
        return CompressionUtils.decompress((InputStream)stream, (String)object.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HttpFirehoseFactory that = (HttpFirehoseFactory)((Object)o);
        return Objects.equals(this.uris, that.uris) && this.getMaxCacheCapacityBytes() == that.getMaxCacheCapacityBytes() && this.getMaxFetchCapacityBytes() == that.getMaxFetchCapacityBytes() && this.getPrefetchTriggerBytes() == that.getPrefetchTriggerBytes() && this.getFetchTimeout() == that.getFetchTimeout() && this.getMaxFetchRetry() == that.getMaxFetchRetry() && this.httpAuthenticationUsername.equals(that.getHttpAuthenticationUsername()) && this.httpAuthenticationPasswordProvider.equals(that.getHttpAuthenticationPasswordProvider());
    }

    public int hashCode() {
        return Objects.hash(this.uris, this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry(), this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider);
    }

    protected Predicate<Throwable> getRetryCondition() {
        return e -> e instanceof IOException;
    }

    public FiniteFirehoseFactory<StringInputRowParser, URI> withSplit(InputSplit<URI> split) {
        try {
            return new HttpFirehoseFactory(Collections.singletonList(split.get()), this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry(), this.getHttpAuthenticationUsername(), this.httpAuthenticationPasswordProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    URLConnection openURLConnection(URI object) throws IOException {
        URLConnection urlConnection = object.toURL().openConnection();
        if (!Strings.isNullOrEmpty((String)this.httpAuthenticationUsername) && this.httpAuthenticationPasswordProvider != null) {
            String userPass = this.httpAuthenticationUsername + ":" + this.httpAuthenticationPasswordProvider.getPassword();
            String basicAuthString = "Basic " + Base64.getEncoder().encodeToString(StringUtils.toUtf8((String)userPass));
            urlConnection.setRequestProperty("Authorization", basicAuthString);
        }
        return urlConnection;
    }
}

