/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.plumber;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.realtime.plumber.RejectionPolicy;
import org.apache.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class MessageTimeRejectionPolicyFactory
implements RejectionPolicyFactory {
    @Override
    public RejectionPolicy create(Period windowPeriod) {
        long windowMillis = windowPeriod.toStandardDuration().getMillis();
        return new MessageTimeRejectionPolicy(windowMillis, windowPeriod);
    }

    private static class MessageTimeRejectionPolicy
    implements RejectionPolicy {
        private static final AtomicLongFieldUpdater<MessageTimeRejectionPolicy> maxTimestampUpdater = AtomicLongFieldUpdater.newUpdater(MessageTimeRejectionPolicy.class, "maxTimestamp");
        private final long windowMillis;
        private final Period windowPeriod;
        private volatile long maxTimestamp;

        public MessageTimeRejectionPolicy(long windowMillis, Period windowPeriod) {
            this.windowMillis = windowMillis;
            this.windowPeriod = windowPeriod;
            this.maxTimestamp = -4611686018427387904L;
        }

        @Override
        public DateTime getCurrMaxTime() {
            return DateTimes.utc((long)this.maxTimestamp);
        }

        @Override
        public boolean accept(long timestamp) {
            long maxTimestamp = this.maxTimestamp;
            if (timestamp > maxTimestamp) {
                maxTimestamp = this.tryUpdateMaxTimestamp(timestamp);
            }
            return timestamp >= maxTimestamp - this.windowMillis;
        }

        private long tryUpdateMaxTimestamp(long timestamp) {
            long currentMaxTimestamp;
            do {
                if (timestamp > (currentMaxTimestamp = this.maxTimestamp)) continue;
                return currentMaxTimestamp;
            } while (!maxTimestampUpdater.compareAndSet(this, currentMaxTimestamp, timestamp));
            return timestamp;
        }

        public String toString() {
            return StringUtils.format((String)"messageTime-%s", (Object[])new Object[]{this.windowPeriod});
        }
    }
}

