/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryManager;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.joda.time.DateTime;

@LazySingleton
@Path(value="/druid/v2/")
public class QueryResource
implements QueryCountStatsProvider {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    protected static final int RESPONSE_CTX_HEADER_LEN_LIMIT = 7168;
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_ETAG = "ETag";
    protected final QueryLifecycleFactory queryLifecycleFactory;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final ObjectMapper serializeDateTimeAsLongJsonMapper;
    protected final ObjectMapper serializeDateTimeAsLongSmileMapper;
    protected final QueryManager queryManager;
    protected final AuthConfig authConfig;
    protected final AuthorizerMapper authorizerMapper;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final AtomicLong successfulQueryCount = new AtomicLong();
    private final AtomicLong failedQueryCount = new AtomicLong();
    private final AtomicLong interruptedQueryCount = new AtomicLong();

    @Inject
    public QueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryManager queryManager, AuthConfig authConfig, AuthorizerMapper authorizerMapper, GenericQueryMetricsFactory queryMetricsFactory) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.serializeDateTimeAsLongJsonMapper = this.serializeDataTimeAsLong(jsonMapper);
        this.serializeDateTimeAsLongSmileMapper = this.serializeDataTimeAsLong(smileMapper);
        this.queryManager = queryManager;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        Access authResult;
        Set<String> datasources;
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", new Object[]{queryId});
        }
        if ((datasources = this.queryManager.getQueryDatasources(queryId)) == null) {
            log.warn("QueryId [%s] not registered with QueryManager, cannot cancel", new Object[]{queryId});
            datasources = new TreeSet<String>();
        }
        if (!(authResult = AuthorizationUtils.authorizeAllResourceActions(req, (Iterable<ResourceAction>)Iterables.transform(datasources, AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR), this.authorizerMapper)).isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        this.queryManager.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, final @Context HttpServletRequest req) throws IOException {
        final QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
        Query query = null;
        String acceptHeader = req.getHeader("Accept");
        if (Strings.isNullOrEmpty((String)acceptHeader)) {
            acceptHeader = req.getContentType();
        }
        ResponseContext context = this.createContext(acceptHeader, pretty != null);
        final String currThreadName = Thread.currentThread().getName();
        try {
            Access authResult;
            queryLifecycle.initialize(this.readQuery(req, in, context));
            query = queryLifecycle.getQuery();
            String queryId = query.getId();
            Thread.currentThread().setName(StringUtils.format((String)"%s[%s_%s_%s]", (Object[])new Object[]{currThreadName, query.getType(), query.getDataSource().getNames(), queryId}));
            if (log.isDebugEnabled()) {
                log.debug("Got query [%s]", new Object[]{query});
            }
            if (!(authResult = queryLifecycle.authorize(req)).isAllowed()) {
                throw new ForbiddenException(authResult.toString());
            }
            QueryLifecycle.QueryResponse queryResponse = queryLifecycle.execute();
            Sequence results = queryResponse.getResults();
            Map<String, Object> responseContext = queryResponse.getResponseContext();
            String prevEtag = QueryResource.getPreviousEtag(req);
            if (prevEtag != null && prevEtag.equals(responseContext.get(HEADER_ETAG))) {
                queryLifecycle.emitLogsAndMetrics(null, req.getRemoteAddr(), -1L);
                this.successfulQueryCount.incrementAndGet();
                Response response = Response.notModified().build();
                return response;
            }
            final Yielder yielder = Yielders.each((Sequence)results);
            try {
                boolean shouldFinalize = QueryContexts.isFinalize((Query)query, (boolean)true);
                boolean serializeDateTimeAsLong = QueryContexts.isSerializeDateTimeAsLong((Query)query, (boolean)false) || !shouldFinalize && QueryContexts.isSerializeDateTimeAsLongInner((Query)query, (boolean)false);
                final ObjectWriter jsonWriter = context.newOutputWriter(serializeDateTimeAsLong);
                Response.ResponseBuilder builder = Response.ok((Object)new StreamingOutput(){

                    public void write(OutputStream outputStream) throws WebApplicationException {
                        Exception e = null;
                        CountingOutputStream os = new CountingOutputStream(outputStream);
                        try {
                            jsonWriter.writeValue((OutputStream)os, (Object)yielder);
                            os.flush();
                            os.close();
                        }
                        catch (Exception ex) {
                            e = ex;
                            log.error((Throwable)ex, "Unable to send query response.", new Object[0]);
                            throw new RuntimeException(ex);
                        }
                        finally {
                            Thread.currentThread().setName(currThreadName);
                            queryLifecycle.emitLogsAndMetrics(e, req.getRemoteAddr(), os.getCount());
                            if (e == null) {
                                QueryResource.this.successfulQueryCount.incrementAndGet();
                            } else {
                                QueryResource.this.failedQueryCount.incrementAndGet();
                            }
                        }
                    }
                }, (String)context.getContentType()).header("X-Druid-Query-Id", (Object)queryId);
                if (responseContext.get(HEADER_ETAG) != null) {
                    builder.header(HEADER_ETAG, responseContext.get(HEADER_ETAG));
                    responseContext.remove(HEADER_ETAG);
                }
                DirectDruidClient.removeMagicResponseContextFields(responseContext);
                String responseCtxString = this.jsonMapper.writeValueAsString(responseContext);
                if (responseCtxString.length() > 7168) {
                    log.warn("Response Context truncated for id [%s] . Full context is [%s].", new Object[]{queryId, responseCtxString});
                    responseCtxString = responseCtxString.substring(0, 7168);
                }
                Response response = builder.header("X-Druid-Response-Context", (Object)responseCtxString).build();
                return response;
            }
            catch (Exception e) {
                Response response;
                try {
                    yielder.close();
                    throw new RuntimeException(e);
                }
                catch (QueryInterruptedException e2) {
                    this.interruptedQueryCount.incrementAndGet();
                    queryLifecycle.emitLogsAndMetrics(e2, req.getRemoteAddr(), -1L);
                    response = context.gotError((Exception)((Object)e2));
                    return response;
                }
                catch (ForbiddenException e3) {
                    throw e3;
                }
                catch (Exception e4) {
                    this.failedQueryCount.incrementAndGet();
                    queryLifecycle.emitLogsAndMetrics(e4, req.getRemoteAddr(), -1L);
                    log.makeAlert((Throwable)e4, "Exception handling request", new Object[0]).addData("exception", (Object)e4.toString()).addData("query", (Object)(query != null ? query.toString() : "unparseable query")).addData("peer", (Object)req.getRemoteAddr()).emit();
                    response = context.gotError(e4);
                    return response;
                }
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private Query<?> readQuery(HttpServletRequest req, InputStream in, ResponseContext context) throws IOException {
        Query baseQuery = (Query)this.getMapperForRequest(req.getContentType()).readValue(in, Query.class);
        String prevEtag = QueryResource.getPreviousEtag(req);
        if (prevEtag != null) {
            baseQuery = baseQuery.withOverriddenContext((Map)ImmutableMap.of((Object)HEADER_IF_NONE_MATCH, (Object)prevEtag));
        }
        return baseQuery;
    }

    private static String getPreviousEtag(HttpServletRequest req) {
        return req.getHeader(HEADER_IF_NONE_MATCH);
    }

    protected ObjectMapper getMapperForRequest(String requestContentType) {
        boolean isSmile = "application/x-jackson-smile".equals(requestContentType) || APPLICATION_SMILE.equals(requestContentType);
        return isSmile ? this.smileMapper : this.jsonMapper;
    }

    protected ObjectMapper serializeDataTimeAsLong(ObjectMapper mapper) {
        return mapper.copy().registerModule((Module)new SimpleModule().addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer()));
    }

    protected ResponseContext createContext(String requestType, boolean pretty) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType) || APPLICATION_SMILE.equals(requestType);
        String contentType = isSmile ? "application/x-jackson-smile" : "application/json";
        return new ResponseContext(contentType, isSmile ? this.smileMapper : this.jsonMapper, isSmile ? this.serializeDateTimeAsLongSmileMapper : this.serializeDateTimeAsLongJsonMapper, pretty);
    }

    @Override
    public long getSuccessfulQueryCount() {
        return this.successfulQueryCount.get();
    }

    @Override
    public long getFailedQueryCount() {
        return this.failedQueryCount.get();
    }

    @Override
    public long getInterruptedQueryCount() {
        return this.interruptedQueryCount.get();
    }

    protected static class ResponseContext {
        private final String contentType;
        private final ObjectMapper inputMapper;
        private final ObjectMapper serializeDateTimeAsLongInputMapper;
        private final boolean isPretty;

        ResponseContext(String contentType, ObjectMapper inputMapper, ObjectMapper serializeDateTimeAsLongInputMapper, boolean isPretty) {
            this.contentType = contentType;
            this.inputMapper = inputMapper;
            this.serializeDateTimeAsLongInputMapper = serializeDateTimeAsLongInputMapper;
            this.isPretty = isPretty;
        }

        String getContentType() {
            return this.contentType;
        }

        public ObjectMapper getObjectMapper() {
            return this.inputMapper;
        }

        ObjectWriter newOutputWriter(boolean serializeDateTimeAsLong) {
            ObjectMapper mapper = serializeDateTimeAsLong ? this.serializeDateTimeAsLongInputMapper : this.inputMapper;
            return this.isPretty ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
        }

        Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter(false).writeValueAsString(object), (String)this.contentType).build();
        }

        Response gotError(Exception e) throws IOException {
            return Response.serverError().type(this.contentType).entity((Object)this.newOutputWriter(false).writeValueAsBytes((Object)QueryInterruptedException.wrapIfNeeded((Throwable)e))).build();
        }
    }
}

