/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;

public class SegmentManager {
    private static final EmittingLogger log = new EmittingLogger(SegmentManager.class);
    private final SegmentLoader segmentLoader;
    private final ConcurrentHashMap<String, DataSourceState> dataSources = new ConcurrentHashMap();

    @Inject
    public SegmentManager(SegmentLoader segmentLoader) {
        this.segmentLoader = segmentLoader;
    }

    @VisibleForTesting
    Map<String, DataSourceState> getDataSources() {
        return this.dataSources;
    }

    public Map<String, Long> getDataSourceSizes() {
        return this.dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((DataSourceState)entry.getValue()).getTotalSegmentSize()));
    }

    public Map<String, Long> getDataSourceCounts() {
        return this.dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((DataSourceState)entry.getValue()).getNumSegments()));
    }

    public boolean isSegmentCached(DataSegment segment) {
        return this.segmentLoader.isSegmentLoaded(segment);
    }

    @Nullable
    public VersionedIntervalTimeline<String, ReferenceCountingSegment> getTimeline(String dataSource) {
        DataSourceState dataSourceState = this.dataSources.get(dataSource);
        return dataSourceState == null ? null : dataSourceState.getTimeline();
    }

    public boolean loadSegment(DataSegment segment) throws SegmentLoadingException {
        Segment adapter = this.getAdapter(segment);
        SettableSupplier resultSupplier = new SettableSupplier();
        this.dataSources.compute(segment.getDataSource(), (k, v) -> {
            DataSourceState dataSourceState = v == null ? new DataSourceState() : v;
            VersionedIntervalTimeline<String, ReferenceCountingSegment> loadedIntervals = dataSourceState.getTimeline();
            PartitionHolder entry = loadedIntervals.findEntry(segment.getInterval(), (Object)segment.getVersion());
            if (entry != null && entry.getChunk(segment.getShardSpec().getPartitionNum()) != null) {
                log.warn("Told to load an adapter for segment[%s] that already exists", new Object[]{segment.getId()});
                resultSupplier.set((Object)false);
            } else {
                loadedIntervals.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)new ReferenceCountingSegment(adapter)));
                dataSourceState.addSegment(segment);
                resultSupplier.set((Object)true);
            }
            return dataSourceState;
        });
        return (Boolean)resultSupplier.get();
    }

    private Segment getAdapter(DataSegment segment) throws SegmentLoadingException {
        Segment adapter;
        try {
            adapter = this.segmentLoader.getSegment(segment);
        }
        catch (SegmentLoadingException e) {
            this.segmentLoader.cleanup(segment);
            throw e;
        }
        if (adapter == null) {
            throw new SegmentLoadingException("Null adapter from loadSpec[%s]", new Object[]{segment.getLoadSpec()});
        }
        return adapter;
    }

    public void dropSegment(DataSegment segment) {
        String dataSource = segment.getDataSource();
        this.dataSources.compute(dataSource, (dataSourceName, dataSourceState) -> {
            if (dataSourceState == null) {
                log.info("Told to delete a queryable for a dataSource[%s] that doesn't exist.", new Object[]{dataSourceName});
            } else {
                ReferenceCountingSegment oldQueryable;
                VersionedIntervalTimeline<String, ReferenceCountingSegment> loadedIntervals = dataSourceState.getTimeline();
                PartitionChunk removed = loadedIntervals.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk(null));
                ReferenceCountingSegment referenceCountingSegment = oldQueryable = removed == null ? null : (ReferenceCountingSegment)removed.getObject();
                if (oldQueryable != null) {
                    ((DataSourceState)dataSourceState).removeSegment(segment);
                    log.info("Attempting to close segment %s", new Object[]{segment.getId()});
                    oldQueryable.close();
                } else {
                    log.info("Told to delete a queryable on dataSource[%s] for interval[%s] and version[%s] that I don't have.", new Object[]{dataSourceName, segment.getInterval(), segment.getVersion()});
                }
            }
            return dataSourceState == null || dataSourceState.isEmpty() ? null : dataSourceState;
        });
        this.segmentLoader.cleanup(segment);
    }

    public static class DataSourceState {
        private final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        private long totalSegmentSize;
        private long numSegments;

        private void addSegment(DataSegment segment) {
            this.totalSegmentSize += segment.getSize();
            ++this.numSegments;
        }

        private void removeSegment(DataSegment segment) {
            this.totalSegmentSize -= segment.getSize();
            --this.numSegments;
        }

        public VersionedIntervalTimeline<String, ReferenceCountingSegment> getTimeline() {
            return this.timeline;
        }

        public long getTotalSegmentSize() {
            return this.totalSegmentSize;
        }

        public long getNumSegments() {
            return this.numSegments;
        }

        public boolean isEmpty() {
            return this.numSegments == 0L;
        }
    }
}

