/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.server.audit.AuditManagerProvider;
import org.apache.druid.server.audit.SQLAuditManager;
import org.apache.druid.server.audit.SQLAuditManagerConfig;

public class SQLAuditManagerProvider
implements AuditManagerProvider {
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final SQLMetadataConnector connector;
    private final Lifecycle lifecycle;
    private final ServiceEmitter emitter;
    private final ObjectMapper mapper;
    private final SQLAuditManagerConfig config;

    @Inject
    public SQLAuditManagerProvider(Supplier<MetadataStorageTablesConfig> dbTables, SQLMetadataConnector connector, Lifecycle lifecycle, ServiceEmitter emitter, @Json ObjectMapper mapper, SQLAuditManagerConfig config) {
        this.dbTables = dbTables;
        this.connector = connector;
        this.lifecycle = lifecycle;
        this.emitter = emitter;
        this.mapper = mapper;
        this.config = config;
    }

    @Override
    public AuditManager get() {
        try {
            this.lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                public void start() {
                    SQLAuditManagerProvider.this.connector.createAuditTable();
                }

                public void stop() {
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new SQLAuditManager(this.connector, this.dbTables, this.emitter, this.mapper, this.config);
    }
}

