/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.druid.server.coordination.ChangeRequestHistory;

public final class ChangeRequestsSnapshot<T> {
    private final boolean resetCounter;
    private final String resetCause;
    private final ChangeRequestHistory.Counter counter;
    private final List<T> requests;

    public static <T> ChangeRequestsSnapshot<T> success(ChangeRequestHistory.Counter counter, List<T> requests) {
        return new ChangeRequestsSnapshot<T>(false, null, counter, requests);
    }

    public static <T> ChangeRequestsSnapshot<T> fail(String resetCause) {
        return new ChangeRequestsSnapshot<T>(true, resetCause, null, null);
    }

    @JsonCreator
    public ChangeRequestsSnapshot(@JsonProperty(value="resetCounter") boolean resetCounter, @JsonProperty(value="resetCause") String resetCause, @JsonProperty(value="counter") ChangeRequestHistory.Counter counter, @JsonProperty(value="requests") List<T> requests) {
        this.resetCounter = resetCounter;
        this.resetCause = resetCause;
        if (resetCounter) {
            Preconditions.checkNotNull((Object)resetCause, (Object)"NULL resetCause when resetCounter is true.");
        }
        this.counter = counter;
        this.requests = requests;
    }

    @JsonProperty
    public boolean isResetCounter() {
        return this.resetCounter;
    }

    @JsonProperty
    public String getResetCause() {
        return this.resetCause;
    }

    @JsonProperty
    public ChangeRequestHistory.Counter getCounter() {
        return this.counter;
    }

    @JsonProperty
    public List<T> getRequests() {
        return this.requests;
    }

    public String toString() {
        return "ChangeRequestsSnapshot{resetCounter=" + this.resetCounter + ", resetCause='" + this.resetCause + '\'' + ", counter=" + this.counter + ", requests=" + this.requests + '}';
    }
}

